#include "line.h"
#include <math.h>

BDLine::BDLine(){
  initMem();
}
//------------------------------------------------------------------------------
void BDLine::initMem(){
  x1 = 0;
  y1 = 0;
  x2 = 0;
  y2 = 0;
  //  sidedness_memory1=-1;
}

//------------------------------------------------------------------------------
BDLine::BDLine(float _x1,float _y1, float _x2,float _y2){
  initMem();
  //this makes sure that x1 is always the smallest of the pair.
  x1 = _x2;
  y1 = _y2;
  x2 = _x1;
  y2 = _y1;
  fixDirection();
}
//------------------------------------------------------------------------------
BDLine::~BDLine(){

}
//------------------------------------------------------------------------------
float BDLine::getX1(){
  return x1;
}
//------------------------------------------------------------------------------
float BDLine::getY1(){
  return y1;
}
//------------------------------------------------------------------------------
float BDLine::getX2(){
  return x2;
}
//------------------------------------------------------------------------------
float BDLine::getY2(){
  return y2;
}
//------------------------------------------------------------------------------
void BDLine::set1(float x,float y){
  x1 = x;
  y1 = y;
}
//------------------------------------------------------------------------------
void BDLine::set2(float x,float y){
  x2 = x;
  y2 = y;
}
//------------------------------------------------------------------------------

float fabs(float a){
  if(a<0)return -a;
  else return a;
}

int BDLine::whichSideY(float x,float y){
  //get the slope - M in y=mx+b
  float m = (y2-y1)/(x2-x1);
  float b = y1 - m*x1;
  
  int fallen_outside=0;
  //now find out if it's hitting the line seg, and not the entire ray.
  
  //  if(x>x1||x<x2){//if fallen outside
  //  return 3;
  // }else{
  if((x1>x2)&&(m<0)){
    return x*m+b<y;// here is whether or not it's above.
  } else {
    return x*m+b>y;// here is whether or not it's above.
  }
    //  }
}
//------------------------------------------------------------------------------
int BDLine::fixDirection(){
  //this makes sure that x1 is always the smallest of the pair.
  //swap everyone
  int swapReport=0;
  if(x1 < x2){
    float t = x1;
    x1=x2;
    x2=t;

    t = y1;
    y1=y2;
    y2=t;
    swapReport = 1;
  } else {
    swapReport = 0;
  }
  
  //also fix verticality.
  if(x1==x2){
    x1+=0.1;
  }
  return swapReport;
}

