#include "Vector.h"
#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#if defined(macintosh)
//#include <Types.h>
#endif


void Vector::alphabetizeStrings(){
	long tmp;
	int foundOne = true;
	while(foundOne){
	  foundOne = false;
	  list_item* current;
	  current = head;
	  if (current==NULL)return; 
	  if(count>1){
	    for(int i=0;i<count-1;i++){
	      current = current->next;
	      if(0>strcmp((char*)(current->item),
			  (char*)(current->previous->item))){
		tmp = current->item;
		current->item = current->previous->item;
		current->previous->item=tmp;
		foundOne = true;
	      }
	    }  
	  }else return;//why sort if there is only one item?
	}
}


int Vector::hasString(char*s){
  list_item* current;
  current = head;
  if (current==NULL)return NULL;
  
  for(int i=0;i<count;i++){
    if(0==strcmp((char*)(current->item),s))return true;
    current = current->next;
  }  
  return false;
}


void Vector::orderKeysNumerically(){
  list_item* current;
  if (current==NULL)return;
  if(this->count>2){
    int foundOne = true;
    while(foundOne==true){
      foundOne=false;
      current = head;
      for(int i=2;i<this->count ;i+=2){
	current = current->next;//skip the value
	current = current->next;//advance to the next keyname
	if( current->item < current->previous->previous->item ){
	  //switch them around.
	  long p = current->previous->previous->item;
	  long p2 = current->previous->item;
				current->previous->previous->item =
				  current->item;
				current->previous->item = current->next->item;
				current->item = p;
				current->next->item = p2;
				foundOne = true;
			}
	  	 }
	 }
  }
}

void Vector::deleteMatch(long match){
  list_item* current;
  if(head==NULL||tail==NULL)return;
  int foundOne = 1;
  while(foundOne){
    current = head;
    foundOne = 0;
    for(int i=0;i<this->count;i++){
      if(current->item==match){
	if(current==head){
	  if(count>1){
	    current->next->previous = NULL;
	  }
	  head = current->next;
	  delete current;
	  //current=head;
	  foundOne = 1;
	  this->count--;
	  break;
	}else if(current==tail){
	  //if(count>1)
	  current->previous->next = NULL;
	  tail = current->previous;
	  delete current;
	  //current = tail;
	  foundOne = 1;
	  this->count--;
	  break;	
	}else{//for everyone else in between
	  current->previous->next = current->next;
	  current->next->previous = current->previous;
	  //list_item * newcur = current->next;//buffer for new current
	  delete current;
	  //current = newcur;//saved from buffer.
	  foundOne = 1;
	  this->count--;
	  break;	
	}
      }
      //advance if needed
      current = current->next;
    }
    
  }
}


long Vector::getKey(char*key){
  list_item* current;
  current = head;
  if (current==NULL)return NULL;
  for(int i=0;i<this->count ;i+=2){
  	 	if(!strcmp((char*)(current->item),key)){
			return (long)current->next->item;
		}
  		current = current->next;//skip the value
		current = current->next;//advance to the next keyname
  }
  return NULL;
}

//------------------------------------------
void Vector::set(long index, long value){
  list_item* current;
  current = head;
  
  if (current==NULL)return;
  
  for(int i=0;i<index;i++){
      current = current->next;
  }
  current->item = value;
}

//------------------------------------------
long Vector::get(long index){
  list_item* current;
  current = head;
  if (current==NULL)return NULL;
  for(int i=0;i<index;i++){
      current = current->next;
  }
  return current->item;
}

//------------------------------------------

Vector::Vector(){              // list constructor
  head = NULL;
  tail = NULL;
  count = 0;
}
Vector::~Vector(){             // list destructor
  list_item* current;
  current = head;
  if (current==NULL);
  int foundOne = 1;
  while(foundOne){
    foundOne = 0;
    for(int i=0;i<this->count;i+=2){
      list_item *c = current;
      current = current->next;
      delete c;
    }
  }
}

//------------------------------------------
int Vector::push( long data ){
  list_item* new_item;
  
  new_item = new list_item();
  if ( new_item == NULL ) return false;
  //strcpy( new_item -> string, data );
  new_item->next = NULL;
  new_item->previous = NULL;
  
  new_item->item = data;
  
  if ( head == NULL || tail == NULL){
    tail = new_item;
    head = new_item;
    new_item -> next = NULL;
    new_item -> previous = NULL;
  } else {
    tail -> next = new_item;
    new_item -> previous = tail;
    new_item -> next = NULL;
    tail = new_item;
  }
  count++;
  return true;
}
//------------------------------------------
long Vector::pop(){
  if(count>0){
    list_item* n=tail;
    tail=tail->previous;
    count--;
    long theItem = n->item;
    delete n;
    return theItem;
  }else return 0;
}
//-------------------------------------------------------------------------------
long Vector::unshift(){
  list_item* n=head;
  head=head->next;
  count--;
  long theItem = n->item;
  delete n;
  return theItem;
}
//-------------------------------------------------------------------------------

int Vector::shift( long data ){
  list_item* new_item;

  new_item = new list_item;
  if ( new_item == NULL )
    return false;
  //strcpy( new_item -> string, data );
  new_item->item = data;
  if ( head == NULL )
    {
      tail = new_item;
      head = new_item;
      new_item -> next = NULL;
      new_item -> previous = NULL;
    }
  else
    {
      head -> previous = new_item;
      new_item -> next = head;
      new_item -> previous = NULL;
      head = new_item;
    }
  count++;
  return true;
}
//-------------------------------------------------------------------------------
void Vector::display_reverse(){
  /*
  list_item* current;
  current = tail;
  if ( current == NULL )
    cout << "\n\n Empty list!\n";
  else
    cout << "\n\n List:\n";

  while ( current != NULL )
    {
      cout << " " << (current -> item) << "\n";
      current = current -> previous;
    }
	*/
}
//////////////////////////////////////////////////////////////////////////////

void FloatVector::orderKeysNumerically(){
  list_itemf* current;
  if (current==NULL)return;
  if(this->count>2){
  	int foundOne = true;
	while(foundOne==true){
		foundOne=false;
		current = head;
	 	 for(int i=2;i<this->count ;i+=2){
			current = current->next;//skip the value
			current = current->next;//advance to the next keyname
	  		if( current->item < current->previous->previous->item ){
				//switch them around.
				float p = current->previous->previous->item;
				float p2 = current->previous->item;
				current->previous->previous->item = current->item;
				current->previous->item = current->next->item;
				current->item = p;
				current->next->item = p2;
				foundOne = true;
			}
	  	 }
	 }
  }
}

//------------------------------------------
void FloatVector::set(long index, float value){
  list_itemf* current;
  current = head;
  
  if (current==NULL)return;
  
  for(int i=0;i<index;i++){
      current = current->next;
  }
  current->item = value;
}

//------------------------------------------
float FloatVector::get(long index){
  list_itemf* current;
  current = head;
  if (current==NULL)return NULL;
  for(int i=0;i<index;i++){
      current = current->next;
  }
  return current->item;
}

//------------------------------------------

FloatVector::FloatVector(){
  head = NULL;
  tail = NULL;
  count = 0;
}
//------------------------------------------
int FloatVector::push( float data ){
  list_itemf* new_item;

  new_item = new list_itemf;
  if ( new_item == NULL )
    return false;
  //strcpy( new_item -> string, data );

  new_item->item = data;
  
  if ( head == NULL )
    {
      tail = new_item;
      head = new_item;
      new_item -> next = NULL;
      new_item -> previous = NULL;
    }
  else
    {
      tail -> next = new_item;
      new_item -> previous = tail;
      new_item -> next = NULL;
      tail = new_item;
    }
  count++;
  return true;
}
//------------------------------------------
float FloatVector::pop(){
  list_itemf* n=tail;
  tail=tail->previous;
  count--;
  return n->item;
}
//-------------------------------------------------------------------------------
float FloatVector::unshift(){
  list_itemf* n=head;
  head=head->next;
  count--;
  return n->item;
}
//-------------------------------------------------------------------------------

int FloatVector::shift( float data ){
  list_itemf* new_item;

  new_item = new list_itemf;
  if ( new_item == NULL )
    return false;
  //strcpy( new_item -> string, data );
  new_item->item = data;
  if ( head == NULL )
    {
      tail = new_item;
      head = new_item;
      new_item -> next = NULL;
      new_item -> previous = NULL;
    }
  else
    {
      head -> previous = new_item;
      new_item -> next = head;
      new_item -> previous = NULL;
      head = new_item;
    }
  count++;
  return true;
}
//-------------------------------------------------------------------------------
void FloatVector::display_reverse(){
  /*
  list_itemf* current;
  current = tail;
  if ( current == NULL )
    cout << "\n\n Empty list!\n";
  else
    cout << "\n\n List:\n";

  while ( current != NULL )
    {
      cout << " " << (current -> item) << "\n";
      current = current -> previous;
    }
	*/
}
