#ifndef _VECTOR_H_
#define _VECTOR_H_

#include <iostream.h>
#include <stdlib.h>
#include <string.h>

//enum bool{false, true};

struct list_item{
  long item;
  list_item* next;
  list_item* previous;
};


class Vector{

public:

  list_item* head;  // Ptr to head of list
  list_item* tail;  // Ptr to tail of list
//------------------------------------------

  long count;
  
  long get(long index);  
  void set(long index, long value);  
  Vector(); // Constructor - initialise empty list
  ~Vector();
  int push( long );   // Add string to tail of list
  long pop();   // get string from tail and delete it
  long unshift();   // get string from head and delete it
  int shift( long );   // Add string to head of list
  void display(char*);         // Display list
  void display_reverse(); // Display list in reverse order
  void deleteMatch(long match);

  long getKey(char*);
  void orderKeysNumerically();
  int hasString(char*s);
  void alphabetizeStrings();

};

////////////////////////////////////////////////////////////

struct list_itemf{
  float item;
  list_itemf* next;
  list_itemf* previous;
};


class FloatVector{

public:

  list_itemf* head;  // Ptr to head of list
  list_itemf* tail;  // Ptr to tail of list
//------------------------------------------

  long count;
  
  float get(long index);  
  void set(long index, float value);  
  FloatVector(); // Constructor - initialise empty list
  int push( float );   // Add string to tail of list
  float pop();   // get string from tail and delete it
  float unshift();   // get string from head and delete it
  int shift( float );   // Add string to head of list
  void display(char*);         // Display list
  void display_reverse(); // Display list in reverse order
  
  void orderKeysNumerically();
};



#endif

