#ifndef _BALL_H_
#define _BALL_H_

#include <stdio.h>
#include <stdlib.h>
#include "fmod.h"
#include "vector.h"
/*
  Ball object - by Josh Nimoy
  bounces around and has controllable forces.
*/

class Ball {
 private:
  FSOUND_SAMPLE *sound;
  char *netstr;//buffer for net printing.
  float oldX;
  float oldY;
  float x;
  float y;
  float forceX;
  float forceY;
  int channel;
  float jitter;
  unsigned char volume;
  long *lastBounceTimes;
  unsigned long  bounceTimeDelta;
  unsigned long tooMuchBouncingThreshold;
 public:
  void setPos(float x,float y);
  float getX();
  float getY();
  float getOldX();
  float getOldY();
  Ball(float x,float y,int channel);
  Ball(float x_,float y_,float oldX_,float oldY_,float forceX_,float forceY_,float jitter);
  Ball();
  ~Ball();
  void stepPhysics();
  void applyForce(float x,float y);
  void initMem();
  void reflectInDirection(float reflectAngle);
  float getForceRadius();
  void bounce();
  void amnesia();
  void rollBackOnePos();
  float getJitter();
  float getForceX();
  float getForceY();
};

#endif

