#include "bitmapfont.h"
#include "jttoolkit.h"

BitmapFont::BitmapFont(){

}

BitmapFont::~BitmapFont(){
  delete charWidths;
}

int BitmapFont::open(char file[], int texturesize){
  base = glGenLists(256);
  charWidths = new float[256];
  char filename[256];
  for(int i=0;i<256;i++){
    //#if defined(macintosh)		
    //sprintf(filename,":%s:%i.raw",file,i);
    //#else
    sprintf(filename,"%s/%i.raw",file,i);
    //#endif
    
    //printf("%i ", i);
    int tex=loadBitmapCharRAW((unsigned char*)filename,texturesize,texturesize);
    
    glNewList(base+i,GL_COMPILE);
    
    if(tex!=0){
      glBindTexture(GL_TEXTURE_2D,tex);
      
      glBegin(GL_QUADS);
      glTexCoord2f(0,0);
      glVertex2f(0,0);
      
      glTexCoord2f(1,0);
      glVertex2f(1,0);
      
      glTexCoord2f(1,1);
      glVertex2f(1,1);
      
      glTexCoord2f(0,1);
      glVertex2f(0,1);
      glEnd();
    }
    glEndList();
  }
  
  //now get all the meta	
  
  //#if defined(macintosh)		
  //	sprintf(filename,":%s:kerning.raw",file);
  //#else
  sprintf(filename,"%s/kerning.raw",file);
  //#endif
  
  ifstream kernin;
  kernin.open(filename);
  
  
  if(getFileSize((unsigned char*)filename)==0){
    printf("bitmapfont.open() didn't find /kerning.raw\n",0);
    exit(0);
  }else{
    kernin>>offx;
    kernin>>offy;
    for(int i=0;i<256;i++){
      kernin>>charWidths[i];
      charWidths[i]/=1240.0;
    }
  }
  
  //getting the offset
  
}

void BitmapFont::drawChar(char c){
  glCallList(base+c);
}

void BitmapFont::drawString(char *inputstr,float size){
  glPushMatrix();
  glScalef(size,size,size);
  glTranslatef( -(1.0-offx/255.0) , -(1.0-offy/255.0) , 0 );
  
  for(int i=0;i<=strlen(inputstr);i++){
    this->drawChar(inputstr[i]);
    glTranslatef( (float)charWidths[inputstr[i]] ,0,0);
  }
  glPopMatrix();
}

float BitmapFont::getStringWidth(char *inputstr,int size){
  float strw=0;	
  for(int i=0;i<strlen(inputstr);i++){
    //this->drawChar(inputstr[i]);
    strw+=size*(float)charWidths[inputstr[i]] ;
  }
  return strw;
}

