#include "jttoolkit.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iostream.h> 
#include <fstream.h>
#include <OpenGL/gl.h>


//#include "gl2ps.h"
#if defined (macintosh)
#include <ApplicationServices/ApplicationServices.h>
#endif

#define use_perspective 1
#define VERBOSE 0
//turn this on and off for speed

//---- user-global access functions

int ticks(){return _ticks;}
int width(){return _width;}
int height(){return _height;}
int mouseX(){return _mouseX;}
int mouseY(){return _mouseY;}

//--------------


void *threadFunc(void*stuff){
}

//------------------------------------------------------------------------
void initfmod(){
  //if(!FSOUND_Init(48000, 1024, FSOUND_INIT_GLOBALFOCUS)){
  //  printf("%s\n",FMOD_ErrorString(FSOUND_GetError()));
  //}
}
//------------------------------------------------------------------------




float friction(){return _friction;}
void setFriction(float f){_friction = f;}

float frequencyRange(){return _frequencyRange;}
void setFrequencyRange(float f){_frequencyRange = f;}

void drawUnitSquare(){
  glBegin(GL_QUADS);
  glTexCoord2f(0,0);glVertex2f(0,0);	
  glTexCoord2f(1,0);glVertex2f(1,0);
  glTexCoord2f(1,1);glVertex2f(1,1);
  glTexCoord2f(0,1);glVertex2f(0,1);
  glEnd();
}

void toggleFullScreen(){
  fullscreenmode=!fullscreenmode;
  if(fullscreenmode){
    glutFullScreen();
  } else {
    glutReshapeWindow(640,480);
    glutPositionWindow(100,100);
  }
}

char* trimLeft(char*buff){
	//count how many to offset backward
	int whiteCount = 0;
	for(int i=0;i<strlen(buff);i++){
		if(buff[i]==' '||buff[i]=='\r'||buff[i]=='\n'||buff[i]=='\t'){
			whiteCount++;
		}else{
			break;
		}
	}
	if(whiteCount>0){
		for(int b=0;b<strlen(buff)-whiteCount;b++){
			buff[b] = buff[b+whiteCount];
		}
	}
	return buff;
}

int loadBitmapCharRAW(unsigned char *filename, int imageWidth, int imageHeight){
	unsigned char *f = stringFromFile(filename);
	if(getFileSize(filename)==0)return 0;
	unsigned char *f_alphad = new unsigned char[imageWidth*imageHeight*4];
	for(int y=0;y<imageHeight;y++){
		for(int x=0;x<imageWidth;x++){
			f_alphad[y*imageWidth*4+4*x  ] = 255-f[y*imageWidth+x];
			f_alphad[y*imageWidth*4+4*x+1] = 255-f[y*imageWidth+x];
			f_alphad[y*imageWidth*4+4*x+2] = 255-f[y*imageWidth+x];
			f_alphad[y*imageWidth*4+4*x+3] = (f[y*imageWidth+x]/8.0f);
		}
	}
	GLuint  t;
	glGenTextures(1,&t);
	glBindTexture(GL_TEXTURE_2D, t);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexImage2D(GL_TEXTURE_2D, 0,4, imageWidth, imageHeight, 0,
		     GL_RGBA, GL_UNSIGNED_BYTE, f_alphad);
	//#if defined(macintosh)
	delete f_alphad;
	delete f;
	//#endif
	return t;
}


unsigned int loadAlphaCutoutTextureRAW(unsigned char *filename,
				       int imageWidth, int imageHeight,
				       int bgRed,int bgGreen,int bgBlue){

  unsigned char *f = stringFromFile(filename);
  GLuint t;
  unsigned char *newf = new unsigned char[imageWidth*imageHeight*4];
  for(int i=0;i<imageWidth*imageHeight;i++){
    newf[i*4+0] =  f[i*3+0];
    newf[i*4+1] =  f[i*3+1];
    newf[i*4+2] =  f[i*3+2];
    if(f[i*3+0]==bgRed&&f[i*3+1]==bgGreen&&f[i*3+2]==bgBlue){
      newf[i*4+3] =  0;
      newf[i*4+2]=0;//blank out all the greenscreen pixels
      newf[i*4+1]=0;
      newf[i*4+0]=0;
    }else{
      newf[i*4+3] =  255;
    }
  }
  glGenTextures(1,&t);
  glBindTexture(GL_TEXTURE_2D, t);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexImage2D(GL_TEXTURE_2D, 0,4, imageWidth, imageHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, newf);
  return t;
}
//--------------------------------------------------------------------------------------------
unsigned int loadAlphaCutoutTextureRAWList(const char *filename, int imageWidth, int imageHeight,int bgRed,int bgGreen,int bgBlue){
  int tex = loadAlphaCutoutTextureRAW((unsigned char*)filename, imageWidth, imageHeight, bgRed, bgGreen, bgBlue);
        int t = glGenLists(1);
	glNewList(t, GL_COMPILE);
	glBindTexture(GL_TEXTURE_2D, tex);
	glColor3f(1,1,1);
	drawUnitSquare();
	glEndList();
	return t;
}
int loadTextureRAW(unsigned char *filename, int imageWidth, int imageHeight){

	unsigned char *f = stringFromFile(filename);
	//printf("[%i %i %i] \n",f[0],f[1],f[2]);
	//if(f==NULL){
	//  exit(0);
	//}
	GLuint t;
	glGenTextures(1,&t);
	glBindTexture(GL_TEXTURE_2D, t);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexImage2D(GL_TEXTURE_2D, 0,3, imageWidth, imageHeight, 0, GL_RGB, GL_UNSIGNED_BYTE, f);

	//free(f);

	return t;
}
//--------------------------------------------------------------------------------------------
int loadTextureAlphaRAWData(unsigned char *f, int imageWidth, int imageHeight){
  GLuint t;
  glGenTextures(1,&t);
  glBindTexture(GL_TEXTURE_2D, t);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexImage2D(GL_TEXTURE_2D, 0,4, imageWidth, imageHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, f);
  return t;
}

void writeps(int format, int sort, int options, int nbcol, char *file){

// 	FILE *fp;

// 	#if defined(macintosh)//this is a subtle distinction to avoid compiler warnings
// 		long viewport[4];
// 	#else
// 		int viewport[4];
// 	#endif

// 	int state = GL2PS_OVERFLOW, buffsize = 0;
// 	viewport[0] = 0;
//   	viewport[1] = 0;
//   	viewport[2] = width();
//   	viewport[3] = height();
//   	fp = fopen(file, "w");
//   	if(!fp){
//     	if(VERBOSE)printf("Unable to open file %s for writing\n", file);
//     	exit(1);
//   	}
//   	fflush(stdout);
//   	while(state == GL2PS_OVERFLOW){
//    		buffsize += 1024*1024;
// 		gl2psBeginPage(file, "test", viewport, format, sort, options, GL_RGBA, 0, NULL, nbcol, nbcol, nbcol, buffsize, fp, file);
//     	_execute_frame();
//     	state = gl2psEndPage();
//   	}
//   	fclose(fp);

//   	//fflush(stdout);
}

void exportPostscript(unsigned char *filename){
//     writeps( GL2PS_EPS,
// 			 GL2PS_SIMPLE_SORT,
// 			 GL2PS_OCCLUSION_CULL | GL2PS_DRAW_BACKGROUND,
// 			 0,
// 			 filename);
}

void fileFromString(unsigned char *fname, char *data, long datasize){
	long i=0;
	FILE *fp = fopen((const char*)fname,"wb");
	for(i=0;i<datasize;i++){
		fputc(data[i],fp);
	}
	fclose(fp);
}


//--------------------------------------------------------------------


unsigned char* stringFromFile(unsigned char *fname){
	long fsize;
	unsigned char *a;

	if(fname==NULL){
	  if(VERBOSE)printf("err: stringFromFile: filename was null\n",NULL);
	  return 0;
	}
	fsize = getFileSize(fname);

	if(fsize==0){
	  if(VERBOSE)printf("err: stringFromFile: file size was zero\n",NULL);
	  return 0;
	}
	a = new unsigned char[fsize+1];
	
	if(a==NULL){
	  if(VERBOSE)printf("err: stringFromFile: memory allocation failed\n",NULL);
	  return 0;
	}
	
	getFile(fname,a,fsize);
	a[fsize]=0;
	return a;
}


//--------------------------------------------------------------------

long getFileSize(unsigned char *fname){
 	FILE *fp;
 	long fsize;
 	if (fname == NULL){
  		if(VERBOSE)printf("err: getFileSize: filename was null\n",NULL);
		return 0;
	}
	fp = fopen((const char*)fname, "rb");
	if (fp == NULL){
  		if(VERBOSE)printf("err: getFileSize: file stream failed\n",NULL);
		return 0;
	}
  	if(fseek(fp, 0, SEEK_END)!=0){
  		if(VERBOSE)printf("err: getFileSize: fseek failed\n",NULL);
	}
  	fsize = ftell(fp);
  	fclose(fp);
  	return fsize;
}


//--------------------------------------------------------------------

void getFile(unsigned char *filename, unsigned char *buff, int length){
	unsigned char c=0;
	long buffcnt=0;
	long i=0;
	ifstream f;
	#if defined(macintosh)
		f.open((const char*)filename);
	#else
		f.open((const char*)filename, ios::binary);
	#endif
		f.read((char*)buff, length);
	//for(i=0;i<length;i++){
	//	printf("{%c}",buff[i]);
	//}
	f.close();
}


//--------------------------------------------------------------------

void hideMouse(){

 #if defined(macintosh)
  	//MAC
 	HideCursor();
 #else
 	//WINDOWS
 	ShowCursor(FALSE);
 #endif


}

//--------------------------------------------------------------------

void showMouse(){
 #if defined(macintosh)
  	//MAC
 	ShowCursor();
 #else
 	//WINDOWS
 	ShowCursor(TRUE);
 #endif
}

void display(){}
void display2(){}

void _execute_frame(){
  int penta_bootlogo;
  if(penta_firstloop){//first time!
    penta_firstloop = false;
    //glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_COLOR); //use for black on white text. (note, colors will invert)  
    setup();
  }else{
    
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
    glPushMatrix();
#if defined(use_perspective)
    glTranslatef(-width()/2.0f,height()/2.0,-height()/2.0);
    glScalef(1,-1,1);
#endif  
    loop();
    glPopMatrix();
    glutSwapBuffers();
    //glFlush();
    //glutPostRedisplay();
    _ticks++;
  }
}

void idle(){
  if(glutGet(GLUT_ELAPSED_TIME) - lastGlutFrameTime > frameRate){
    _execute_frame();
    lastGlutFrameTime = glutGet(GLUT_ELAPSED_TIME);
  }
}


void timerFunc(int v) {
  //if(glutGet(GLUT_ELAPSED_TIME) - lastGlutFrameTime > frameRate){
  //_execute_frame();
  //}
  //glutTimerFunc(frameRate,timerFunc,0);
}

void preKeyDown(unsigned char k, int special){
  if(special){
    if(k==11){
      toggleFullScreen();
    }
  } else {
    //non special
    if(k==27){
      exit(0);
    }else if (k==KEY_DELETE || k==KEY_BACKSPACE){


    } else if (k==6){//ctrl+f on a mac
      toggleFullScreen();
    } else {

    }
  }

}

void keyboardDown(unsigned char k,int x,int y){
	_mouseX=x;
	_mouseY=y;
	preKeyDown(k,0);
	_keyDown(k,0);
}

void keyboardUp(unsigned char k,int x,int y){
  _mouseX=x;
  _mouseY=y;
  //printf("keyboardUp: %c %i\n",k);
  _keyUp(k,0);
}


void specialFunc(int k,int x,int y){
  _mouseX=x;
  _mouseY=y;
  preKeyDown(k,1);
  _keyDown(k,1);
}

void mouseMotionFunc(int x, int y){
  _mouseX=x;
  _mouseY=y;

}

void mousePassiveMotionFunc(int x, int y){
  _mouseX=x;
  _mouseY=y;
  //  printf("%i %i\n",_mouseX,_mouseY);
}

void mouseFunc(int button, int state, int x, int y){
  _mouseX=x;
  _mouseY=y;
  if(state==GLUT_DOWN)_mouseDown();
  else _mouseUp();
}

void reshape(int w,int h){
  //  if(glutGetWindow()==MainWindowID){
  if(1){
    
    _width = w;
    _height = h;
    //	to keep it propertional & let the window stretch
    //	glMatrixMode(GL_PROJECTION);
    //	glLoadIdentity();
    glViewport(0,0,w,h);
    //	if(w<h){
    //		float r = ((float)h/(float)w);
    //		glOrtho(-1,1,-r,r,-2,2);
    //	}else{
    float r = ((float)w/(float)h);
    //		glOrtho(-r,r,-1,1,-2,2);
    //	}
    //	this->draw();
    
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    
#if defined(use_perspective)
    gluPerspective(90,(float)w/(float)h,0.0001,10000);
#else
    glOrtho(0,w,h,0,-10000,10000);
#endif
    //glFrustum(-2, 2, -2, 2, 1.0f, 100.0f);
    
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    
  } else { //then i can assume for now that it was the output console window.
    
    glViewport(0,0,w,h);
    float r = ((float)w/(float)h);
    
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    
    //#if defined(use_perspective)
    //gluPerspective(90,(float)w/(float)h,0.0001,10000);
    //#else
    glOrtho(0,w,h,0,-10000,10000);
    //#endif
    //glFrustum(-2, 2, -2, 2, 1.0f, 100.0f);
    
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
  }
  //  jt_resizeDrawBuffer();
}

void jt_resizeDrawBuffer(){
  //  delete [] drawbuffer;
  //  drawbuffer = new unsigned char[width()*height()*4];
}

int main(int argc,char** argv){
  //initialize pixel buffer
  //  drawbuffer = new unsigned char[GAMEWIDTH*GAMEHEIGHT*4];
  //for(int i=0;i<100*100;i++){
    // drawbuffer[i*4+0] = (unsigned char)(randomFloat()*255);
//     drawbuffer[i*4+1] = (unsigned char)(randomFloat()*255);
//     drawbuffer[i*4+2] = (unsigned char)(randomFloat()*255);
//    drawbuffer[i*4+3] = 255;
  //}
  
  glutInit(&argc,argv);
  glutInitDisplayMode (GLUT_DOUBLE|GLUT_RGBA);
  glutInitWindowSize (640,480);
  glutInitWindowPosition (100,100);
  
  //glutGameModeString("640x480:32@60");
  //if(glutGameModeGet(GLUT_GAME_MODE_POSSIBLE)){
  //   glutEnterGameMode();
  //}else{
  glutCreateWindow (" ");
  //}
  
  glutIdleFunc(idle);
  glutDisplayFunc(display);
  glutReshapeFunc(reshape);
  glutMouseFunc(mouseFunc);
  glutMotionFunc(mouseMotionFunc);
  glutPassiveMotionFunc(mousePassiveMotionFunc);
  glutKeyboardFunc (keyboardDown);
  glutKeyboardUpFunc (keyboardUp);
  glutSpecialFunc (specialFunc);
  //glutTimerFunc(frameRate,timerFunc,0);
  
  // a whole bunch of switches for the openGL engine
  //glEnable(GL_TEXTURE_2D);
  glEnable(GL_BLEND);
  glEnable(GL_DEPTH_TEST);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_COLOR);
  glEnable(GL_LINE_SMOOTH);
  //glEnable(GL_POLYGON_SMOOTH);
  glLineWidth(1);
  glDepthFunc(GL_LESS);//was GL_LEQUAL
  glClearDepth(1.0f);
  glDisable(GL_DITHER);
  //glShadeModel(GL_SMOOTH);
  glMatrixMode(GL_PROJECTION);	//	 The Projection Matrix
  glLoadIdentity();			// The Projection Matrix
  // Calculate The Aspect Ratio Of The Window
  //gluPerspective(45.0f,(float)wW/(float)wH,0.1f,100.0f);
  //gluLookAt(0,0,1,0,0,0,0,1,0);
  glMatrixMode(GL_MODELVIEW); // The Modelview Matrix
  glLoadIdentity();    // The Modelview Matrix
  //glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	// Perspective Calculations
  //glEnable(GL_FOG);
  //glFogf(GL_FOG_START,-100);
  //glFogf(GL_FOG_END,-200);
  //glFogf(GL_FOG_DENSITY,0.1);
  //float r[] = {0.5,0.5,0.5,0.5};
  //glFogfv(GL_FOG_COLOR,r);
  //--------------------------------------------------------------------------------
  glClearColor(0,0,0,0);
  //also, if that doesn't work,  check if the users screen is 640x48, then fullscreen the game.
  //#if defined(macintosh)
  //problem with fullscreen - it disables the glut passive motion func.
  //#else
  if(fullscreenmode)glutFullScreen();
  //#endif

  glutMainLoop();

  //do we ever even get here?
  //FSOUND_Close();
  stop();
  exit(0);
  return 0;
}

int buildScreenFont(char *fontName, int size){
  return 0;
}


void _draw_single_screenFont(int fontID, char*text){
  
  glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);
  
}

void drawScreenFont(int fontID, char*text,int tracking){
  int i;
  int drawScreenFont_buffpt=0;
  int lineCounter=0;
  if (text == NULL)return;
  glPushAttrib(GL_LIST_BIT);
  glRasterPos3f(0,lineCounter,0);
  glListBase(fontID);
  for(i=0;i<strlen(text);i++){
    if(text[i]=='\n'){
      drawScreenFont_buff[drawScreenFont_buffpt]=0;
      _draw_single_screenFont(fontID,drawScreenFont_buff);
      lineCounter+=tracking;
      glRasterPos3f(0,lineCounter,0);
      drawScreenFont_buffpt=0;
    }else{
      drawScreenFont_buff[drawScreenFont_buffpt] = text[i];
      drawScreenFont_buffpt++;
    }
  }
  drawScreenFont_buff[drawScreenFont_buffpt]=0;
  _draw_single_screenFont(fontID,drawScreenFont_buff);
  glPopAttrib();
}


void killScreenFont(int fontID){
  glDeleteLists(fontID,256);
}


void lights(){
  glEnable(GL_LIGHT0);
  glEnable(GL_LIGHTING);
  glEnable(GL_COLOR_MATERIAL);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
}



void nolights(){
  glDisable(GL_LIGHT0);
  glDisable(GL_LIGHTING);
  glDisable(GL_COLOR_MATERIAL);
}



float randomFloat(){
  return ((float)rand())/((float)RAND_MAX);
}


