#ifndef __JTTOOLKIT__
#define __JTTOOLKIT__

#define macintosh
#define Macintosh

#include <math.h>
#include <time.h>
#include <stdlib.h>

#define PI 3.141592653

#if defined(macintosh)
  #include <GLUT/glut.h>
  #include <OpenGL/gl.h>
#else
  #include <GL/glut.h>
  #include <GL/gl.h>
#endif

#include <iostream.h>
#include <fstream.h> 
#include "Vector.h"
#include "fmod.h"
#include "fmod_errors.h"


#include "project.h"
#include <string.h>
#include "bitmapfont.h"
#include "Letter.h"
#include "Line.h"
#include "quadstretch.h"
#include "draggableCircle.h"

#include <sys/ioctl.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#include <sched.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <sched.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>




#if defined(macintosh)
#define KEY_BACKSPACE 65
#else
#define KEY_BACKSPACE 8
#endif
#define KEY_DELETE 127



#if defined(macintosh)
//MAC
// #include <Fonts.h>
// #include "agl.h"
//#include "/sw/include/libpng/png.h"
//
#else
//WINDOWS
#include <windows.h>
#include <png.h>
//
#endif


//------------ user event prototypes ------------------------------

void setup();
void stop();
void loop();
void _keyDown(int key,int special);
void _keyUp(int key,int special);
void _mouseDown();
void _mouseUp();

// ----------------- user tool function prototypes ------------------------

extern "C"{
  int main(int ,char**);
  char* trimLeft(char*buff);
  void drawUnitSquare();

  //void postQuit(JTScene *newScene);
  //tells the system to quit out of the scene while the scene is not executing any events!
  void toggleFullScreen();
  int loadBitmapCharRAW(unsigned char *filename, int imageWidth, int imageHeight);
  //imports a RAW interlaced RGB image and returns a texture ID.
  //BitmapFont object sits ontop of this function.

  int loadTextureRAW(unsigned char *filename, int imageWidth, int imageHeight);
  //imports a RAW interlaced RGB image and returns a texture ID.
  
  int loadTextureAlphaRAWData(unsigned char *f, int imageWidth, int imageHeight);
  //produces a texture map, given an RGBA array.

  int getPNGWidth(unsigned char *filename);
  
  int loadTexturePNG(unsigned char *filename);
  //imports an 8-bit RGBA PNG image and returns a texture ID.
  
  int loadTexturePNGList(const char *filename);
  //imports an 8-bit RGBA PNG image and returns a display list with the image being drawn.
  
  unsigned int loadAlphaCutoutTextureRAWList(const char*filename, int imageWidth, int imageHeight, int bgRed, int bgGreen, int bgBlue);
  //acts like loadAlphaCutoutTextureRAW, except returns a display list.a  
  
  unsigned int loadAlphaCutoutTextureRAW(unsigned char *filename, int imageWidth, int imageHeight,int bgRed,int bgGreen,int bgBlue);
  // imports a RAW interlaced RGB image and returns a texture ID.
  // The texture creates an alpha channel based on the last 3 args

  void exportPostscript(char *filename);
  //exports the current frame to EPS vector-based file format.

  void fileFromString(unsigned char *fname, char *data, long datasize);
  //writes the bytes in null-terminated data string to file fname.

  unsigned char* stringFromFile(unsigned char *fname);
  //returns a file pointer to the contents of the file.
  //when you are done using this string, free it using free(ptr);

  long getFileSize(unsigned char *fname);
  //returns the size of a file in bytes.

  void getFile(unsigned char *filename, unsigned char *buff, int length);
  //gets the contents of a file and stores it into a string.

  void hideMouse();
  //hides the mouse

  void showMouse();
  //shows the mouse

  int buildScreenFont(char *fontName,int size);
  //loads a font and returns the ID

  void drawScreenFont(int fontID,char*text,int tracking);
  //draws the font to the screen as text

  void killScreenFont(int fontID);
  //unloads the fontID (i've never needed to call this)

  float randomFloat();
  // gives you a random float between 0.0 and 1.0

  void lights();
  // enables GL lighting (defaultly off)

  void nolights();
  //disables GL lighting


  //------------------------ internal prototypes-------------------------------

  void display();
  void idle();
  void timerFunc(int v);
  void keyboardDown(unsigned char k,int x,int y);
  void keyboardUp  (unsigned char k,int x, int y);
  void specialFunc(int k, int x,int y);
  void mouseMotionFunc(int x, int y);
  void mousePassiveMotionFunc(int x, int y);
  void mouseFunc(int state, int button, int x, int y);
  void reshape(int w,int h);
  void _draw_single_screenFont(int fontID, char*text);
  void writeps(int format, int sort, int options, int nbcol, char *file);
  void _execute_frame();//the actual frame call.
};

//----------------- useful globals for high level programmers -----------------

static unsigned long _ticks = 0;
int ticks();

static unsigned long _width = 0;
int width();

static unsigned long _height = 0;
int height();

static unsigned long _mouseX = 0;
int mouseX();

static unsigned long _mouseY = 0;
int mouseY();

static float _friction = 0.99997f;
float friction();
void setFriction(float f);

static float _frequencyRange = 50000;
float frequencyRange();
void setFrequencyRange(float f);

//-----------------internal globals--------------------------------------------

static int penta_firstloop=1;
static unsigned long frameRate = 1;
//this is misleading. it's actually the pause time in milliseconds.
static char drawScreenFont_buff[1024*256];//text max
static int lastGlutFrameTime=0;
static unsigned char *drawbuffer;

static int fullscreenmode = 0;

void jt_resizeDrawBuffer();

#if defined(macintosh)
//MAC CLASSIC
#else
//WINDOWS
static HWND theHwnd=0;
#endif

//-----------------------------------------------------------------------------
#endif

