#include "myron.h"
#include <math.h>


Myron::Myron(){
#if defined(Macintosh)
#else
   InitializeQTML(0);
#endif 

}

Myron::~Myron(){
#if defined(Macintosh)
#else
  TerminateQTML();
#endif

}


//-----------------------------------------------------------------------------

void Myron::start(int w,int h){

	
	UserData mySGVideoSettings = NULL;
	//-- begin user code	                                                                              
	ComponentDescription theDesc;                                                 
	//ComponentResult theresult;                                                    
	Component sgCompID ;                                                          
	Rect videoRect;                                                               
	int error;                                                                                                   
#if defined(Macintosh)
#else
        int returnval=0;
#endif

	this->imageWidth = w;                                                            
	this->imageHeight = h;                     

	this->findGlobs_state = 1; //make a default

	this->thisGlobCount=0;
	this->minDensity_state = 100;
	this->maxDensity_state = 0;
	this->globBoxListCount = 0;

	this->globPixelList 	= new unsigned char[w*h];

	this->cameraPixels = new unsigned char[w*h*3];

	this->retinaPixels = new unsigned char[w*h*3];

	this->differencePixels = new unsigned char[w*h*3];
	this->hijackPixels = new unsigned char[w*h*3];

	
	this->globIDs 		= new int[w*h];
	this->stackX 		= new int[w*h];
	this->stackY 		= new int[w*h];

	this->thisGlobXs 	= new int[w*h];
	this->thisGlobYs 	= new int[w*h];

	this->globBoxList	= new int[w*h*4];
	this->globCenterPoints = new int[w*h*2];
	this->globEdgePointList  = new int[w*h*3];

	this->globQuadList  = new int[w*h*8];
	this->globEdgePointListCount = 0;



	this->globPixelLists				= new int[w*h*3];
	this->globPixelListsCount		= 0;

	this->trackColorRed = 0;
	this->trackColorGreen = 0;
	this->trackColorBlue = 0;
	this->sensitivity_state = 10;
	this->trackNot = 0;
	this->adaptivity_state = 0.0;
	this->hijackNext = 0;


	//set return val before hand      
	//returnval = 1; 

#if defined(Macintosh)
    error =NewGWorld(&this->videogworld, 32, &videoRect, nil, nil,0 );	
#endif

    if (error != noErr ){
    //ThrowErr(this->pValueInterface->IntegerToValue(0, &pCall->resultValue));
    //printf("error creating gworld\n",0);                                        
    //ExitToShell();                                                              
  }                                                         
  EnterMovies();
  



  this->gSeqGrabber = 0L;                                                          
  this->gVideoChannel = 0L;                                                        
  theDesc.componentType = SeqGrabComponentType;                                 
  theDesc.componentSubType = 0L;                                                
  theDesc.componentManufacturer = 0L; //'appl';                            
    theDesc.componentFlags = 0L;                                                  
    theDesc.componentFlagsMask = 0L;                                              
    sgCompID = FindNextComponent(nil, &theDesc);                                  
    this->gSeqGrabber = OpenComponent(sgCompID);                                     
    SGInitialize(this->gSeqGrabber);                                                 
    MacSetRect(&videoRect,0,0,this->imageWidth,this->imageHeight);                      
#if defined(Macintosh)
    NewGWorld ( &(this->videogworld), 32, &videoRect, nil, nil,0 );
#else
	QTNewGWorld ( &(this->videogworld) ,k32BGRAPixelFormat ,&videoRect,0,0,0);// IV-2817
	this->videoDC=(HDC)GetPortHDC((GrafPtr)(this->videogworld));

	win32pixbuff = new unsigned char[w*h*3];
	bmap = CreateCompatibleBitmap(this->videoDC,w,h);
	bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	bmi.bmiHeader.biWidth = w;
	bmi.bmiHeader.biHeight = h;
	bmi.bmiHeader.biPlanes = 1;
	bmi.bmiHeader.biBitCount = 24;
	bmi.bmiHeader.biCompression = BI_RGB;
	bmi.bmiHeader.biSizeImage = w*h*3;
	offDC = CreateCompatibleDC(this->videoDC);
	SelectObject(offDC,bmap);
#endif

	SGSetGWorld(this->gSeqGrabber,this->videogworld, nil);//videogworld5                
    SGNewChannel(this->gSeqGrabber, VideoMediaType, &this->gVideoChannel);              
    SGSetChannelUsage(this->gVideoChannel, seqGrabPreview |                          
		      seqGrabRecord | seqGrabPlayDuringRecord);                   
    if (SGSetFrameRate(this->gVideoChannel,30) != noErr) SysBeep(10);                
    SGSetChannelBounds(this->gVideoChannel, &videoRect);                             
    // end rozin's code


    //now load some saved camera settings
    GetSettingsPreference(&mySGVideoSettings);

    if (mySGVideoSettings) {
      // use the saved settings preference to configure the SGChannel
      SGSetChannelSettings(this->gSeqGrabber, this->gVideoChannel, mySGVideoSettings, 0);
      DisposeUserData(mySGVideoSettings);
    }
   
    SGStartPreview(this->gSeqGrabber);           
    
}

//-----------------------------------------------------------------------------

void Myron::stop(){
 #if defined(Macintosh)
 #else
  DeleteObject(bmap);
  DeleteDC(offDC);
  delete [] win32pixbuff;
  #endif

  SGDisposeChannel(this->gSeqGrabber,this->gVideoChannel);                            
  CloseComponent(this->gSeqGrabber);                                               
  DisposeGWorld(this->videogworld);


  delete [] this->globPixelList;
  delete [] this->cameraPixels;
  delete [] this->retinaPixels;
  delete [] this->differencePixels;
  delete [] this->hijackPixels;
  delete [] this->globIDs;
  delete [] this->stackX;
  delete [] this->stackY;
  delete [] this->thisGlobXs;
  delete [] this->thisGlobYs;
  
  delete [] this->globBoxList;
  delete [] this->globCenterPoints;
  delete [] this->globPixelLists;
  delete [] this->globEdgePointList;
  delete [] this->globQuadList;

#if defined(Macintosh)
#else
  TerminateQTML();
#endif

}

//-----------------------------------------------------------------------------

void Myron::update(){
  long y;                                                              
  unsigned short videoRowBytes;                                  
  Ptr videoBaseAddress;                                       
  PixMapHandle videoPixmap;                                        
  //unsigned char R,G,B;                                                          
  //float distance;                                                               
  Rect videoRect;                                                    
  
  MacSetRect(&videoRect,0,0,this->imageWidth,this->imageHeight);                      

  if(!this->hijackNext){
	//don't update the camera if you ain't gonna use it.
#if defined(Macintosh)
	SGIdle(this->gSeqGrabber);
#else
	SGIdle(this->gVideoChannel);
#endif
  }
  videoPixmap=GetGWorldPixMap(this->videogworld);                                 
  
  videoRowBytes  = ((*(videoPixmap))->rowBytes) & 0x7fff;                      
  
  videoBaseAddress   = GetPixBaseAddr(videoPixmap );                           
  
  //construct the cameraImage    
  if(this->hijackNext){
    this->hijackNext = 0;
    for(int i=0;i<this->imageWidth*this->imageHeight*3;i++){
      this->cameraPixels[i] = this->hijackPixels[i];
    }
  } else {

#if defined(Macintosh)
	  
	  for(y=0;y<this->imageHeight;y++)for(int x=0;x<this->imageWidth;x++){
		  this->cameraPixels[y*3*this->imageWidth+x*3+0] = videoBaseAddress[y*4*(this->imageWidth+4)+x*4+1];
		  this->cameraPixels[y*3*this->imageWidth+x*3+1] = videoBaseAddress[y*4*(this->imageWidth+4)+x*4+2];
		  this->cameraPixels[y*3*this->imageWidth+x*3+2] = videoBaseAddress[y*4*(this->imageWidth+4)+x*4+3];	 	
	  }

#else

		//copy the bits to there.
		BitBlt(this->offDC,0,0,this->imageWidth,this->imageHeight, this->videoDC,0,0,SRCCOPY);
		GetDIBits(offDC,bmap,0,this->imageHeight,this->win32pixbuff, &(this->bmi), DIB_RGB_COLORS);

	  //GetBitmapBits(bmap,this->imageWidth*this->imageHeight*3,this->cameraPixels);

	  //unsigned char*v = new unsigned char[this->imageHeight*(this->imageWidth+4)*4];
	  for(int y=0;y<this->imageHeight;y++){
		  for(int x=0;x<this->imageWidth;x++){
			COLORREF c = GetPixel(this->videoDC,x,y);
			this->cameraPixels[y*3*this->imageWidth+x*3+0]  = this->win32pixbuff[((this->imageHeight-1)-y)*3*this->imageWidth+x*3+2];
			this->cameraPixels[y*3*this->imageWidth+x*3+1]  = this->win32pixbuff[((this->imageHeight-1)-y)*3*this->imageWidth+x*3+1];
			this->cameraPixels[y*3*this->imageWidth+x*3+2]  = this->win32pixbuff[((this->imageHeight-1)-y)*3*this->imageWidth+x*3+0];
		  }
	  }
	  
#endif

  }
  
  //construct the retinaImage
  if(this->adaptivity_state!=0){
    for(int i=0;i<this->imageWidth*this->imageHeight*3;i++){
      this->retinaPixels[i]+=(unsigned char)((float)(this->cameraPixels[i]-this->retinaPixels[i])/this->adaptivity_state);
    }
  }
  
  //construct the differenceImage
  for(int i=0;i<this->imageWidth*this->imageHeight*3;i++){
    unsigned char c = abs(this->cameraPixels[i]-this->retinaPixels[i]);
    if(c>255)c = 255;
    this->differencePixels[i]=c;
  }	
  
  
  //generate the glob image using thresholding against a color with a sensitivity - for process glob ids.
  for(y=0;y<this->imageHeight;y++){
    for(int x=0;x<this->imageWidth;x++){
      unsigned char r = (unsigned char)(this->differencePixels[y*3*this->imageWidth+x*3+0]);
      unsigned char g = (unsigned char)(this->differencePixels[y*3*this->imageWidth+x*3+1]);
      unsigned char b = (unsigned char)(this->differencePixels[y*3*this->imageWidth+x*3+2]);
      unsigned char tr = this->trackColorRed;
      unsigned char tg = this->trackColorGreen;
      unsigned char tb = this->trackColorBlue;
      float rd = (float)abs(tr-r);
      float gd = (float)abs(tg-g);
      float bd = (float)abs(tb-b);
      int result = rd+gd+bd < this->sensitivity_state;
      if(this->trackNot){
	result = !result;
      }
      if(result) {
	this->globPixelList[y*this->imageWidth+x] = 255;
      } else {
	this->globPixelList[y*this->imageWidth+x] = 0;
      }
      
    }//end for x
  }//end for y



  
  if(this->findGlobs_state==1){ 		//do all the crazy analysis on it
    ProcessGlobIDs();	

  }
  
}

//-----------------------------------------------------------------------------
void Myron::settings(){
  SGSettingsDialog(this->gSeqGrabber, this->gVideoChannel, 0, 0, seqGrabSettingsPreviewOnly, 0, 0);   
  UserData mySGVideoSettings = NULL;
  // get the SGChannel settings cofigured by the user
  SGGetChannelSettings(this->gSeqGrabber, this->gVideoChannel, &mySGVideoSettings, 0);
  // save the settings using the key "sgVideoSettings" 
  SaveSettingsPreference(mySGVideoSettings);
  DisposeUserData(mySGVideoSettings);
}

//-----------------------------------------------------------------------------
unsigned char *Myron::version(){
  //ThrowErr (this->pValueInterface->StringToValue( "BETA 2.0", &(pCall->resultValue) ));
  return (unsigned char*)"BETA 2.0";
}
//-----------------------------------------------------------------------------
void Myron::findGlobs(int state){
  this->findGlobs_state = state;
}
//-----------------------------------------------------------------------------
unsigned char *Myron::globsImage(){
  return this->globPixelList;
}

//-----------------------------------------------------------------------------

void Myron::sensitivity(float val){
  this->sensitivity_state = val;
} 
//-----------------------------------------------------------------------------
void Myron::minDensity(int val){
  this->minDensity_state = val;
}
//-----------------------------------------------------------------------------

void Myron::maxDensity(int val){
	this->maxDensity_state = val;
}
//-----------------------------------------------------------------------------
unsigned char *Myron::cameraImage(){
  return this->cameraPixels;
}
//-----------------------------------------------------------------------------
unsigned char *Myron::image(){
  return this->cameraPixels;
}
//-----------------------------------------------------------------------------

int *Myron::globBoxes(){
  return this->globBoxList;
}
//-----------------------------------------------------------------------------

int Myron::globCount(){
  return this->globBoxListCount;
}
//-----------------------------------------------------------------------------


int *Myron::globCenters(){
  return this->globCenterPoints;
}

//-----------------------------------------------------------------------------

int *Myron::globPixels(){
  return this->globPixelLists;
}

int Myron::globPixelsCount(){
  return this->globPixelListsCount;
}


//-----------------------------------------------------------------------------

int Myron::globEdgePoints(int segmentLength){
  this->globEdgePointListCount = 0;
  
  int w = this->imageWidth;
  int h = this->imageHeight;
  
  MyronPoint p;
  MyronPoint  middle;
  int tag;
  int accumCount=0;
  //float xd;
  //float yd;
  float *samples = new float[w*h*3];
  int samplesCount = 0;
  float *ordered_samples = new float[w*h*3];
  int ordered_samplesCount = 0;
  
  
  #if defined(Macintosh)
  #else
  int addition_accumX = 0;
  int addition_accumY = 0;
  
  
  float centerX = 0;
  float centerY = 0;
  #endif
  
  for(int i=0;i<this->globPixelListsCount;i++){

    tag = this->globPixelLists[i*3+2];
    p.x = this->globPixelLists[i*3+0];
    p.y = this->globPixelLists[i*3+1];
    
    
    //this->pValueInterface->PointToValue(&p,&newval);
    
    if(tag==1){//beginning a glob
      middle.x = (this->globBoxList[accumCount*4+0]+this->globBoxList[accumCount*4+2])/2;
      middle.y = (this->globBoxList[accumCount*4+1]+this->globBoxList[accumCount*4+3])/2;
      samplesCount = 0;
    }
    int foundOne = 0;
    // add a distance entry ONLY if this pixel is an edge.
    if( (p.x-1<0||p.y-1<0||p.x+1>=w||p.y+1>=h) ){//if this pixel is on the edge of the board then it is an edge.
      foundOne = 1;
    } else {
      //amongst the pixels off the edge of the image, there are more edge pixels for the glob.
      if( this->globPixelList[(p.y+1)*w+(p.x)]==0 || this->globPixelList[(p.y)*w+(p.x+1)]==0 ||
	  this->globPixelList[(p.y-1)*w+(p.x)]==0 || this->globPixelList[(p.y)*w+(p.x-1)]==0 ){ //if ANY of the neighbors is 0
	foundOne = 1;
      }
    }
    if(foundOne){	//so add it to the list. (only for edge pixels, that's why the foundOne)
			//xd = p.x-middle.x;
			//yd = p.y-middle.y;
      samples[samplesCount*2+0] = (float)p.x;//(float)i;
      samples[samplesCount*2+1] = (float)p.y;//atan2(yd,xd);
      samplesCount++;
    }
    
    if(tag==2){//ending a glob
      //MyronPoint pp;
      
      
      if(segmentLength<1)segmentLength=1;
      //this->pMmList->NewListValue(&newval);
      for(int ii=0;ii<samplesCount-segmentLength;ii+=segmentLength){
	    if(ii==0){
	      this->globEdgePointList[this->globEdgePointListCount*3+0] = 1;
	    }else{
	      this->globEdgePointList[this->globEdgePointListCount*3+0] = 0;
	    }
	
		this->globEdgePointList[this->globEdgePointListCount*3+1] = (int)samples[ii*2+0];
		this->globEdgePointList[this->globEdgePointListCount*3+2] = (int)samples[ii*2+1];
		this->globEdgePointListCount++;
		//this->pValueInterface->PointToValue(&pp,&newpointval);
		//this->pMmList->AppendValueToList(&newval,&newpointval);
      }
      this->globEdgePointList[(this->globEdgePointListCount-1)*3+0] = 2;
	  
      //this->globEdgePointList[(this->globEdgePointListCount-1)*3+0] = 2; //set the last item to end tag.
      ordered_samplesCount = 0;
      samplesCount = 0;
      
      accumCount++;
    }
  }
  delete [] samples;
  delete [] ordered_samples;
  
  return this->globEdgePointListCount;
}
//-----------------------------------------------------------------------------
int *Myron::globEdgePointsResult(){
  return this->globEdgePointList;
}
//-----------------------------------------------------------------------------
int *Myron::globQuads(float minSideLength,float maxSideLength){
  int i;
  float rads[4];
  int w,h;
  MyronPoint p;
  MyronPoint  middle;
  int tag;
  int accumCount=0;
  float xd;
  float yd;
  float *samples;
  int samplesCount = 0;
  int ii;


  
  w = this->imageWidth;
  h = this->imageHeight;
  

  unsigned char *globPixelListsCopy = new unsigned char[w*h];
  
#if defined(Macintosh)
	for(int memcpycx=0;memcpycx<w*h;memcpycx++){
		globPixelListsCopy[memcpycx]=globPixelLists[memcpycx];
	}
#else
  memcpy(globPixelListsCopy,globPixelLists,w*h);
#endif

  samples = new float[w*h*3];
  for(i=0;i<this->globPixelListsCount;i++){

    tag = this->globPixelLists[i*3+2];
    p.x = this->globPixelLists[i*3+0];
    p.y = this->globPixelLists[i*3+1];
    
    
    //this->pValueInterface->PointToValue(&p,&newval);
    
    if(tag==1){//beginning a glob
      //this->pMmList->NewListValue(&thisList);
      middle.x = (this->globBoxList[accumCount*4+0]+this->globBoxList[accumCount*4+2])/2;
      middle.y = (this->globBoxList[accumCount*4+1]+this->globBoxList[accumCount*4+3])/2;
      samplesCount = 0;
    }
    int foundOne = 0;
    // add a distance entry ONLY if this pixel is an edge.
    if( (p.x-1<0||p.y-1<0||p.x+1>=w||p.y+1>=h) ){//if this pixel is on the edge of the board then it is an edge.
      foundOne = 1;
    } else {
      //amongst the pixels off the edge of the image, there are more edge pixels for the glob.
      if( this->globPixelList[(p.y+1)*w+(p.x)]==0 || this->globPixelList[(p.y)*w+(p.x+1)]==0 ||
	  this->globPixelList[(p.y-1)*w+(p.x)]==0 || this->globPixelList[(p.y)*w+(p.x-1)]==0 ){ //if ANY of the neighbors is 0
	foundOne = 1;
      }
    }
    if(foundOne){	//so add it to the list.
      xd = (float)p.x-(float)middle.x;
      yd = (float)p.y-(float)middle.y;
      samples[samplesCount*2+0] = (float)i;
      samples[samplesCount*2+1] = (float)sqrt(xd*xd+yd*yd);
      samplesCount++;
    }
    
    //this->pMmList->AppendValueToList(&thisList,&newval);
    if(tag==2){//ending a glob
      MyronPoint pp;
      MyronPoint pp2;
      float dist;
      float dist2;
      float ftmp;
      int itmp;
      //bubble sort them.
      
      int foundOne = 1;
      while(foundOne){
	foundOne = 0;
	for(ii=0;ii<samplesCount-1;ii++){
	  pp.x = this->globPixelLists[(int)samples[ii*2+0]*3+0];
	  pp.y = this->globPixelLists[(int)samples[ii*2+0]*3+1];
	  pp2.x = this->globPixelLists[(int)samples[(ii+1)*2+0]*3+0];
	  pp2.y = this->globPixelLists[(int)samples[(ii+1)*2+0]*3+1];
	  dist = samples[ii*2+1];	
	  dist2 = samples[(ii+1)*2+1];
	  if(dist2>dist){
	    //swap
	    ftmp = dist;
	    samples[ii*2+1] = dist2;
	    samples[(ii+1)*2+1] = ftmp;
	    
	    itmp = pp.x;
	    this->globPixelLists[(int)samples[ii*2+0]*3+0] = pp2.x;
	    this->globPixelLists[(int)samples[(ii+1)*2+0]*3+0] = itmp;
	    
	    itmp = pp.y;
	    this->globPixelLists[(int)samples[ii*2+0]*3+1] = pp2.y;
	    this->globPixelLists[(int)samples[(ii+1)*2+0]*3+1] = itmp;
	    
	    foundOne = 1;
	  }
	}
      }
      
      int quadPoints[4*2];
      int ga_quadPoints[4*2];
      float ga=0;
      for(int ci=(int)minSideLength;ci<maxSideLength;ci++){
	//now start at the top of the stack and choose 4 points that are far enough apart.
	
	for(int qci=0;qci<4;qci++){
	  quadPoints[qci*2+0] = middle.x;
	  quadPoints[qci*2+1] = middle.y;
	}
	int quadPointsCount = 0;
	for(ii=0;ii<samplesCount;ii++){
	  pp.x = this->globPixelLists[(int)samples[ii*2+0]*3+0];
	  pp.y = this->globPixelLists[(int)samples[ii*2+0]*3+1];
	  dist = samples[ii*2+1];
	  if(quadPointsCount==0){
	    //immediately add this first point.
	    quadPoints[0] = pp.x;
	    quadPoints[1] = pp.y;
	    quadPointsCount++;
	  } else if(quadPointsCount>3) {
	    break;
	  } else {//this is the middle, so compare to all of them
	    int violated = 0;
	    for(int iii=0;iii<quadPointsCount;iii++){
	      float xd = (float)quadPoints[iii*2+0] - pp.x;
	      float yd =(float) quadPoints[iii*2+1] - pp.y;
	      float d = (float)sqrt(xd*xd+yd*yd);
	      //if(d<=minSideLength){
	      if(d<=ci){
		violated = 1;
	      }
	    }
	    if(violated==0){//then we found one that is away from all the others.
	      quadPoints[quadPointsCount*2+0] = pp.x;
	      quadPoints[quadPointsCount*2+1] = pp.y;
	      quadPointsCount++;
	    }
	  }
	}
	
	//now that we have all the magic 4, rotate around and order them
	
	for(ii=0;ii<4;ii++){
	  rads[ii] = (float)atan2(quadPoints[ii*2+1]-middle.y,quadPoints[ii*2+0]-middle.x);
	}
	
	//now bubble sort.
	foundOne = 1;
	while(foundOne){
	  foundOne = 0;
	  for(int ii=0;ii<3;ii++){
	    if(rads[ii]<rads[ii+1]){
	      float tmp = rads[ii];
	      rads[ii] = rads[ii+1];
	      rads[ii+1] = tmp;
	      
	      tmp = (float)quadPoints[ii*2+0];
	      quadPoints[ii*2+0]=quadPoints[(ii+1)*2+0];
	      quadPoints[(ii+1)*2+0]=(int)tmp;
	      
	      tmp = (float)quadPoints[ii*2+1];
	      quadPoints[ii*2+1]=quadPoints[(ii+1)*2+1];
	      quadPoints[(ii+1)*2+1]=(int)tmp;
	      
	      foundOne = 1;
	    }
	  }
	}
	
	//now calculate the area of this quad.
	float area = getTriangleArea( (float)quadPoints[0],(float)quadPoints[1],
				      (float)quadPoints[2],(float)quadPoints[3],
				      (float)quadPoints[4],(float)quadPoints[5]   );
	area +=      getTriangleArea( (float)quadPoints[4],(float)quadPoints[5],
				      (float)quadPoints[6],(float)quadPoints[7],
				      (float)quadPoints[0],(float)quadPoints[1]   );
	
	//could this area be the biggest?
	if(area>ga){
	  //if so, copy to the thrown
	  ga=area;
	  for(int gi=0;gi<4*2;gi++){
	    ga_quadPoints[gi] = quadPoints[gi];
	  }
	}
	
	
      }//end looping through the area sampling phase.
      
      
      //	MAKE A LIST OF 4 THEN APPEND IT TO RESULT LIST.
      
      //this->pMmList->NewListValue(&newval);
      for(int ica=0;ica<8;ica++){
	     this->globQuadList[accumCount*8+ica] = ga_quadPoints[ica];
      }
      
      
      accumCount++;
    }
  }
  delete samples;
  
#if defined(Macintosh)
	for(int memcpycx=0;memcpycx<w*h;memcpycx++){
		globPixelLists[memcpycx]=globPixelListsCopy[memcpycx];
	}
#else
  memcpy(globPixelLists,globPixelListsCopy,w*h);
#endif

 delete globPixelListsCopy;

  return this->globQuadList;
  
}

//-----------------------------------------------------------------------------

void Myron::trackColor(int red,int green,int blue,int tolerance){
  this->trackColorRed = red;
  this->trackColorGreen = green;
  this->trackColorBlue = blue;
  this->sensitivity_state = (float)tolerance;
  this->trackNot = 0;
}

//-----------------------------------------------------------------------------

void Myron::trackNotColor(int red,int green,int blue,int tolerance){
  this->trackColorRed = red;
  this->trackColorGreen = green;
  this->trackColorBlue = blue;
  this->sensitivity_state = (float)tolerance;
  this->trackNot = 1;
}

//-----------------------------------------------------------------------------

void Myron::average(int region_left,int region_top,
				int region_right, int region_bottom, unsigned char *buff){
  //safety clipping.
  if(region_top < 0)region_top = 0;
  if(region_left < 0)region_left = 0;
  if(region_bottom >= this->imageHeight )region_bottom = this->imageHeight-1;
  if(region_right >= this->imageWidth )region_right = this->imageWidth-1;

  //it seems arbitrary that i am hardwiring this to look at the camera image.
  long r=0;
  long g=0;
  long b=0;
  long counter=0;
  for(int y=region_top;y<region_bottom;y++){
    for(int x=region_left;x<region_right;x++){
      r+=this->differencePixels[y*this->imageWidth*3+x*3+0];
      g+=this->differencePixels[y*this->imageWidth*3+x*3+1];
      b+=this->differencePixels[y*this->imageWidth*3+x*3+2];
      counter++;
    }
  }
  //MessageBox(0,"3","",0);
  if(counter!=0){
	  buff[0] = (unsigned char)(r/counter);
	  buff[1] = (unsigned char)(g/counter);
	  buff[2] = (unsigned char)(b/counter);
  }else{
	  buff[0] = 0;
	  buff[1] = 0;
	  buff[2] = 0;
  }

  
}

//-----------------------------------------------------------------------------

unsigned char *Myron::retinaImage(){
  return this->retinaPixels;
}

//-----------------------------------------------------------------------------


void Myron::adaptivity(float val){
  this->adaptivity_state = val;
}
//-----------------------------------------------------------------------------

void Myron::adapt(){
  for(int y=0;y<this->imageHeight;y++)for(int x=0;x<this->imageWidth;x++){
    this->retinaPixels[y*(this->imageWidth)*3+x*3+0]=this->cameraPixels[y*(this->imageWidth)*3+x*3+0];
    this->retinaPixels[y*(this->imageWidth)*3+x*3+1]=this->cameraPixels[y*(this->imageWidth)*3+x*3+1];
    this->retinaPixels[y*(this->imageWidth)*3+x*3+2]=this->cameraPixels[y*(this->imageWidth)*3+x*3+2];
  }
}
//-----------------------------------------------------------------------------
unsigned char* Myron::differenceImage(){
  return this->differencePixels;
}
//-----------------------------------------------------------------------------
void Myron::hijackRGB(int w,int h,unsigned char * newimage){
  
  for(int y=0;y<this->imageHeight;y++)for(int x=0;x<this->imageWidth;x++){
    if(y>=h||x>=w){
      this->hijackPixels[y*(this->imageWidth)*3+x*3+0] = 0;//blanking out the areas that fall outside.
      this->hijackPixels[y*(this->imageWidth)*3+x*3+1] = 0;
      this->hijackPixels[y*(this->imageWidth)*3+x*3+2] = 0;
    }else{	
      this->hijackPixels[y*(this->imageWidth)*3+x*3+0] = newimage[y*3*w+x*3+0];
      this->hijackPixels[y*(this->imageWidth)*3+x*3+1] = newimage[y*3*w+x*3+1];
      this->hijackPixels[y*(this->imageWidth)*3+x*3+2] = newimage[y*3*w+x*3+2];
    }
  }
  this->hijackNext = 1;
}
//-----------------------------------------------------------------------------
void Myron::hijackARGB(int w,int h,unsigned char * newimage){
  
  for(int y=0;y<this->imageHeight;y++)for(int x=0;x<this->imageWidth;x++){
    if(y>=h||x>=w){
      this->hijackPixels[y*(this->imageWidth)*3+x*3+0] = 0;//blanking out the areas that fall outside.
      this->hijackPixels[y*(this->imageWidth)*3+x*3+1] = 0;
      this->hijackPixels[y*(this->imageWidth)*3+x*3+2] = 0;
    }else{	
      this->hijackPixels[y*(this->imageWidth)*3+x*3+0] = newimage[y*4*w+x*4+1];
      this->hijackPixels[y*(this->imageWidth)*3+x*3+1] = newimage[y*4*w+x*4+2];
      this->hijackPixels[y*(this->imageWidth)*3+x*3+2] = newimage[y*4*w+x*4+3];
    }
  }
  this->hijackNext = 1;
}//-----------------------------------------------------------------------------
void Myron::hijackARGBInvert(int w,int h,unsigned char * newimage){
  
  for(int y=0;y<this->imageHeight;y++)for(int x=0;x<this->imageWidth;x++){
    if(y>=h||x>=w){
      this->hijackPixels[y*(this->imageWidth)*3+x*3+0] = 0;//blanking out the areas that fall outside.
      this->hijackPixels[y*(this->imageWidth)*3+x*3+1] = 0;
      this->hijackPixels[y*(this->imageWidth)*3+x*3+2] = 0;
    }else{	
      this->hijackPixels[y*(this->imageWidth)*3+x*3+0] = newimage[((this->imageHeight-1)-y)*4*w+x*4+2];
      this->hijackPixels[y*(this->imageWidth)*3+x*3+1] = newimage[((this->imageHeight-1)-y)*4*w+x*4+1];
      this->hijackPixels[y*(this->imageWidth)*3+x*3+2] = newimage[((this->imageHeight-1)-y)*4*w+x*4+0];
    }
  }
  this->hijackNext = 1;
}
//-----------------------------------------------------------------------------
OSErr Myron::SaveSettingsPreference(UserData inUserData){
#if defined (Macintosh)
  CFDataRef theCFSettings;
  Handle    hSettings;
  OSErr     err;
    CFStringRef inKey = CFSTR("sgVideoSettings");
  if (NULL == inUserData) return paramErr;
  
  hSettings = NewHandle(0);
  err = MemError();
  
  if (noErr == err) {
    err = PutUserDataIntoHandle(inUserData, hSettings); 
    
    if (noErr == err) {
      HLock(hSettings);
      theCFSettings = CFDataCreate(kCFAllocatorDefault,
                                   (UInt8 *)*hSettings,
                                   GetHandleSize(hSettings));
	  if (theCFSettings) {
        CFPreferencesSetAppValue(inKey, theCFSettings,
                                 kCFPreferencesCurrentApplication);
        CFPreferencesAppSynchronize(kCFPreferencesCurrentApplication);
        CFRelease(theCFSettings);
      }
    }
    
    DisposeHandle(hSettings);
  }
  
  return err;
#else
  //CFDataRef theCFSettings;
  //Handle    handle;
	//OSErr     err;
	if (NULL == inUserData) return 1;

	OSType udType = 0;
	ofstream f;
	f.open("webcam.pref");

	//print the overall size
	Handle h=NewHandle(0);
	int err = PutUserDataIntoHandle(inUserData,h);
	//todo:catch this error

	HLock(h);
	char s[100];
	sprintf(s,"%09i",GetHandleSize(h));
	f<<s;

	for(int ii=0;ii<GetHandleSize(h);ii++){
		f<<(*h)[ii];
	}
	f<<'\n';
	HUnlock(h);
	DisposeHandle(h);
	f.close();

/*	
	int c=0;
  
  while(udType = GetNextUserDataType(inUserData, udType)){
  	  //if ((udType & 0xff000000) == FOUR_CHAR_CODE('\0\0\0')){
	c=CountUserDataType(inUserData,udType);
	for(int i=1;i<=c;i++){
		f<<udType<<'\n';
		f<<((char*)(&udType))[3]<<((char*)(&udType))[2]<<((char*)(&udType))[1]<<((char*)(&udType))[0]<<'\n';
		
		if((udType>>24)==0xA9){
			f<<"(text)\n";
			
			handle = NewHandle(0);
			GetUserDataText(inUserData,handle,udType,i,0);
			
			HLock(handle);
			f<<*handle<<'\n';
			//for(int ii=0;ii<strlen(*handle);ii++){
			//	f<<(int)((unsigned char)((*handle)[i]))<<' ';
			//}
			HUnlock(handle);
			DisposeHandle(handle);
			f<<'\n';
		}else{
			f<<"(binary)\n";
			Handle hData = NewHandle(0);
			int err = GetUserData(inUserData, hData, udType, i);
			if(err){
				//MessageBox(0,"error","",0);
				return 1;
			}
			HLock(hData);
			f<<GetHandleSize(hData)<<'\n';
			for(int ii=0;ii<GetHandleSize(hData);ii++){
				f<<(*hData)[ii];
			}
			f<<'\n';
			HUnlock(hData);
			DisposeHandle(hData);
		}
	}
  }


  //for(int i=0;i<1024;i++){
	//f<<((char*)(inUserData->data))[i];
  //}
 */
   
  return 0;
#endif
}

//-----------------------------------------------------------------------------

// GetSettingsPreference
//    Returns a preference for a specified key as QuickTime UserData
// It is your responsibility to dispose of the returned UserData
OSErr Myron::GetSettingsPreference(UserData *outUserData){


  UserData          theUserData = NULL;
  Handle            theHandle = NULL;
  OSErr             err = paramErr;

#if defined(Macintosh)
  CFPropertyListRef theCFSettings;
  CFStringRef inKey = CFSTR("sgVideoSettings");

  // read the new setttings from our preferences
  theCFSettings = CFPreferencesCopyAppValue(inKey,
					    kCFPreferencesCurrentApplication);
  if (theCFSettings) {
    err = PtrToHand(CFDataGetBytePtr((CFDataRef)theCFSettings), &theHandle,
		    CFDataGetLength((CFDataRef)theCFSettings));
    
    CFRelease(theCFSettings);
    if (theHandle) {
      err = NewUserDataFromHandle(theHandle, &theUserData);
      if (theUserData) {
	*outUserData = theUserData;
      }
      DisposeHandle(theHandle);
    }
  }
  
  return err;
#else


	//char *c = new char[1024];
	
	//Handle h;
	//PtrToHand(c,&h,1024);
	//err = NewUserDataFromHandle(h, outUserData);

	ifstream f;

	f.open("webcam.pref");


	char sc[10];
	for(int i=0;i<10;i++){
		sc[i]=0;
	}
	f.read(sc,9);
	long size;
	size = atoi(sc);
	
	if(size!=0){
		char *buff = new char[size];
		f.read(buff,size);

		err = PtrToHand(buff, &theHandle,size);
		if (theHandle) {
			err = NewUserDataFromHandle(theHandle, &theUserData);
			if (theUserData) {
				*outUserData = theUserData;
			}
			DisposeHandle(theHandle);
		}


		delete [] buff;
	}

	f.close();
    //DisposeHandle(h);

  return err;//not yet implemented for PCs
#endif
}
//-----------------------------------------------------------------------------
int Myron::isEdge(int x,int y){
	if(!((y-1<0)||(y+1>=this->imageHeight)||(x-1<0)||(x+1>=this->imageWidth))){	
	  int pu = this->globPixelList[this->imageWidth*(y-1)+(x  )];//up
	  int pd = this->globPixelList[this->imageWidth*(y+1)+(x  )];//down
	  int pl = this->globPixelList[this->imageWidth*(y  )+(x-1)];//left
	  int pr = this->globPixelList[this->imageWidth*(y  )+(x+1)];//right
  
	  int pul = this->globPixelList[this->imageWidth*(y-1)+(x-1)];//up left
	  int pur = this->globPixelList[this->imageWidth*(y-1)+(x+1)];//up right
	  int pdl = this->globPixelList[this->imageWidth*(y+1)+(x-1)];//down left
	  int pdr = this->globPixelList[this->imageWidth*(y+1)+(x+1)];//down right
  
	  int ps = this->globPixelList[this->imageWidth*(y  )+(x  )];
	  return ((ps!=pu)||(ps!=pd)||(ps!=pl)||(ps!=pr)||
		  (ps!=pul)||(ps!=pur)||(ps!=pdl)||(ps!=pdr));
	}else{
		return 1;
	}

}

//-----------------------------------------------------------------------------
void Myron::stackFriendlyRecursiveGlobFind(int x,int y, int curGlobID){
  // i am proud of myself for writing this without using recursive function calling
  // because that was crashing on Mac OS X - the os having a (defaultly) small stack.
  // i bet linux is the same.
  // -josh
  

  
  this->thisGlobCount = 1;	//clear the current glob data
  int stackCount = 1;	//clear the parsing stack
  this->stackX[0] = x;
  this->stackY[0] = y;
  this->globIDs[y*this->imageWidth+x] = curGlobID;
  this->thisGlobXs[0] = x;
  this->thisGlobYs[0] = y;
  //i just added the stack's first item.
  
  //do all the neighbors of this guy to see if we can start a stack.
  int t;
  int xx;
  int yy;
  



  while(stackCount>0){
    //pop one off.
    xx = this->stackX[stackCount-1];
    yy = this->stackY[stackCount-1];
    stackCount--;
    
    //then check the neighbors if they need to be dealt with later as well.
    
    //left
    if(xx-1>=0){
      t = yy*this->imageWidth+(xx-1);
      if(	this->globIDs[t] == 0 && this->globPixelList[t] == 255 && isEdge(xx,yy) ){
	this->stackX[stackCount] = xx-1;
	this->stackY[stackCount] = yy;
	this->globIDs[t] = curGlobID;
	this->thisGlobXs[this->thisGlobCount] = xx-1;
	this->thisGlobYs[this->thisGlobCount] = yy;
	this->thisGlobCount++;
	stackCount++;
      }
    }
    
    //top
    if(yy-1>=0){
      t = (yy-1)*this->imageWidth+(xx);
      if(	this->globIDs[t] == 0 && this->globPixelList[t] == 255 && isEdge(xx,yy) ){
	this->stackX[stackCount] = xx;
	this->stackY[stackCount] = yy-1;
	this->globIDs[t] = curGlobID;
	this->thisGlobXs[this->thisGlobCount] = xx;
	this->thisGlobYs[this->thisGlobCount] = yy-1;
	this->thisGlobCount++;
	stackCount++;
      }
    }
    
    //bottom
    if(yy+1<this->imageHeight){
      t = (yy+1)*this->imageWidth+(xx);
      if(	this->globIDs[t] == 0 && this->globPixelList[t] == 255 && isEdge(xx,yy) ){
	this->stackX[stackCount] = xx;
	this->stackY[stackCount] = yy+1;
	this->globIDs[t] = curGlobID;
	this->thisGlobXs[this->thisGlobCount] = xx;
	this->thisGlobYs[this->thisGlobCount] = yy+1;
	this->thisGlobCount++;
	stackCount++;
      }
    }
    
    //right
    if(xx+1<this->imageWidth){
      t = (yy)*this->imageWidth+(xx+1);
      if(	this->globIDs[t] == 0 && this->globPixelList[t] == 255 && isEdge(xx,yy) ){
	this->stackX[stackCount] = xx+1;
	this->stackY[stackCount] = yy;
	this->globIDs[t] = curGlobID;
	this->thisGlobXs[this->thisGlobCount] = xx+1;
	this->thisGlobYs[this->thisGlobCount] = yy;
	this->thisGlobCount++;
	stackCount++;
      }
    }
    
  }
}
//-----------------------------------------------------------------------------
void Myron::ProcessGlobIDs(){
  
  //reset the globID buffer.
  
  for(int i=0;i<this->imageWidth*this->imageHeight;i++){
    this->globIDs[i] = 0;
  }

  //erase the global globbox accum buffer.
  this->globBoxListCount = 0;
  this->globPixelListsCount = 0;
  //reset the working glob counter.
  int curGlobID = 0;


  //loop through all the pixels and call the recursive function on them
  for(int y=0;y<this->imageHeight;y++){

    for(int x=0;x<this->imageWidth;x++){
	  
      int t =y*this->imageWidth+x;
  

	  int r1 = isEdge(x,y);
		int r2 = (this->globIDs[t] == 0);
		int r3 = (this->globPixelList[t] == 255);
	
	  if(r2 && r3 && r1 ){
	curGlobID++;

	//found one. so find all the neighbors too.
	stackFriendlyRecursiveGlobFind(x,y,curGlobID);
	
	//now erase the globs below minDensity
	
	int logicaccum = 0;
	if(this->maxDensity_state>this->minDensity_state){//is max density NOT infinite?
	  logicaccum = (this->thisGlobCount>this->maxDensity_state);//then also check for upper bound
	}
	if(this->thisGlobCount<this->minDensity_state||logicaccum){
	  //kill this glob
	  for(int i=0;i<this->thisGlobCount;i++){
	    //turn that pixel black and erase its ID.
	    this->globPixelList[this->thisGlobYs[i]*this->imageWidth+this->thisGlobXs[i]] = 0;
	    this->globIDs   [this->thisGlobYs[i]*this->imageWidth+this->thisGlobXs[i]] = 0;
	  }//end for
	} else {
	  
	  //store the weirdly ordered pixel list for later use
	  for(int i=0;i<this->thisGlobCount;i++){
	    this->globPixelLists[this->globPixelListsCount*3+0] = this->thisGlobXs[i];
	    this->globPixelLists[this->globPixelListsCount*3+1] = this->thisGlobYs[i];
	    //now record whether this is a head or a tail.
	    if(i==0){
	      this->globPixelLists[this->globPixelListsCount*3+2] = 1;
	    }else if(i==this->thisGlobCount-1){
	      this->globPixelLists[this->globPixelListsCount*3+2] = 2;
	    }else{
	      this->globPixelLists[this->globPixelListsCount*3+2] = 0;
	    }
	    this->globPixelListsCount++;
	  }//end for
	  
	   //do further analysis on it.
	   //1. find the bounding box of it.
	  int topmost = 10000000;
	  int bottommost = -1000000;
	  int leftmost = 10000000;
	  int rightmost = -100000000;
#if defined(Macintosh)
	  int i;
#endif
	  for(i=0;i<this->thisGlobCount;i++){
	    if(this->thisGlobXs[i]<leftmost)leftmost=this->thisGlobXs[i];
	    if(this->thisGlobXs[i]>rightmost)rightmost=this->thisGlobXs[i];
	    if(this->thisGlobYs[i]<topmost)topmost=this->thisGlobYs[i];
	    if(this->thisGlobYs[i]>bottommost)bottommost=this->thisGlobYs[i];						
	  }
	  //store this data.
	  this->globBoxList[this->globBoxListCount*4+0] = leftmost;
	  this->globBoxList[this->globBoxListCount*4+1] = topmost;
	  this->globBoxList[this->globBoxListCount*4+2] = rightmost;
	  this->globBoxList[this->globBoxListCount*4+3] = bottommost;
	  this->globBoxListCount++;
	}//end if				
	
      }//end if
    }//end for
  }//end for



#if defined(Macintosh)
	  int i;
#endif

  //calculate centerpoints
  for(i=0;i<this->globBoxListCount;i++){
    this->globCenterPoints[i*2+0] = (this->globBoxList[i*4+0]+this->globBoxList[i*4+2])/2;
    this->globCenterPoints[i*2+1] = (this->globBoxList[i*4+1]+this->globBoxList[i*4+3])/2;
  }

}
//-----------------------------------------------------------------------------

float Myron::getTriangleArea(float x0,float y0,float x1,float y1,float x2,float y2){
#define DISTANCE(x,y,xx,yy) (sqrt((x-xx)*(x-xx)+(y-yy)*(y-yy)))
  double a = DISTANCE(x0,y0,x1,y1);
  double b = DISTANCE(x1,y1,x2,y2);
  double c = DISTANCE(x2,y2,x0,y0);
  double s = 0.5*(a+b+c);
  return (float)sqrt(s*(s-a)*(s-b)*(s-c));
}
//-----------------------------------------------------------------------------
int Myron::width(){
	return this->imageWidth;

}
//-----------------------------------------------------------------------------
int Myron::height(){
	return this->imageHeight;
}

//-----------------------------------------------------------------------------

