/*

Myron
open source vision object initiated by Josh Nimoy in March 2004
adapted from WebCamXtra

*/
 
#ifndef _MYRON_H_
#define _MYRON_H_

#if defined(_WINDOWS)
#else 
#define Macintosh
#endif 

#if defined(Macintosh)
//#if defined(_COMPILER_PROJECTBUILDER_)
	//project builder
 		#include <QuickTime/QuickTimeComponents.h>       
 		#include <CoreFoundation/CFPreferences.h>     
//	#else
	//codewarrior
// 		#include <QuickTimeComponents.h>       
// 		#include <CFPreferences.h> 
/* 	#endif */
#else
	//windows visual studio
	#include "QTML.h"
	#include <QuickTimeComponents.h>
	#include <CFPreferences.h>
	#include <windows.h>
	#include <iostream.h>
	#include <fstream.h>
#endif
	#include <stdio.h>
	#include <stdlib.h>

struct MyronPoint{
  int x;
  int y;
};

class Myron{
 public:
  Myron();
  ~Myron();
  void start(int w,int h);
  void stop();
  void update();
  void settings();
  unsigned char* version();
  void findGlobs(int state);
  unsigned char *globsImage();
  void sensitivity(float val);
  void minDensity(int val);
  void maxDensity(int val);
  unsigned char *cameraImage();
  unsigned char *image();
  int *globBoxes();
  int globCount();
  int *globCenters();
  int *globPixels();
  int globPixelsCount();
  int globEdgePoints(int segmentLength);
  int *globEdgePointsResult();
  int *globQuads(float minSideLength, float maxSideLength);
  void trackColor(int red, int green, int blue, int tolerance);
  void trackNotColor(int red, int green, int blue, int tolerance);
  void average(int left,int top,int right,int bottom, unsigned char *colorbuff);
  unsigned char *retinaImage();
  void adaptivity(float val);
  void adapt();
  unsigned char *differenceImage();
  void hijackRGB(int w,int h,unsigned char * newimage);
  void hijackARGB(int w,int h,unsigned char * newimage);
  void hijackARGBInvert(int w,int h,unsigned char * newimage);
  int width();
  int height();
  
 private:
  //private functions
  void stackFriendlyRecursiveGlobFind(int x,int y, int curGlobID);
  float getTriangleArea(float x0,float y0,float x1,float y1,float x2,float y2);
  int isEdge(int x,int y);
  
  OSErr SaveSettingsPreference(UserData inUserData);
  OSErr GetSettingsPreference(UserData *outUserData);
  void ProcessGlobIDs();
  
  //private variables
  SeqGrabComponent   gSeqGrabber;                                       
  SGChannel          gVideoChannel;                                    
  GWorldPtr          videogworld;                                        
  int                imageWidth;                                        
  int                imageHeight;  
  int                findGlobs_state; 
  unsigned char 	  *globPixelList;
  unsigned char 	  *cameraPixels;
  unsigned char 	  *retinaPixels;
  unsigned char 	  *differencePixels;
  unsigned char 	  *hijackPixels;
  int 	              *globIDs;
  int 				  *stackX;
  int 				  *stackY;
  
  int 				  *thisGlobXs;
  int 				  *thisGlobYs;
  int 				  thisGlobCount;
  int 				  minDensity_state;
  int 				  maxDensity_state;
  
  int 				  *globBoxList;
  int 				  *globQuadList;
  int 				  globBoxListCount;
  
  int 				  *globPixelLists;
  int 				  *globCenterPoints;
  int                             *globEdgePointList;
  int                             globEdgePointListCount;
  int 				  globPixelListsCount;
  
  int						trackColorRed;
  int						trackColorGreen;
  int						trackColorBlue;
  int						trackNot;
  float 				  	sensitivity_state;
  float 				  	adaptivity_state;
  int 				  	hijackNext;

#if defined(Macintosh)
#else
	HDC				  videoDC;

	unsigned char *win32pixbuff;;
	HBITMAP bmap;
	BITMAPINFO bmi;
	HDC offDC;

#endif
 
};

#endif

