#include "jttoolkit.h"
#include "myron.h"

Myron *myron;

int camw = 160;
int camh = 120;

int curpos;
int curpos2;
float rotx = 0;
float roty = 0;
float *zpos;
int rendermode = 0;
void setup(){
	zpos = new float[camw*camh];
	
	hideMouse();
	myron = new Myron();
	myron->start(camw,camh);
	myron->findGlobs(0);
	myron->adaptivity(5.0);
	myron->update();
	myron->adapt();
	toggleFullScreen();
}

void loop(){
	
	rotx+=(mouseX()-rotx)/10.0f;
	roty+=(mouseY()-roty)/10.0f;
	
	myron->update();
	unsigned char *pix = myron->image();
	
	//6.4
	glTranslatef(width()/2, height()/2,0);
	glScalef(4,4,4);
	glRotatef(rotx,0,1,0);
	glRotatef(roty,1,0,0);
	
	
    if(rendermode==2){
		glBegin(GL_LINE_LOOP);
    }   
    if(rendermode==3){
		glBegin(GL_POINTS);
    }
    if(rendermode==4){
		glBegin(GL_POLYGON);
    }
    if(rendermode==5){
		glBegin(GL_QUAD_STRIP);
    }
    if(rendermode==6){
		glDisable(GL_BLEND);
		glBegin(GL_TRIANGLE_FAN);
		glVertex3f(width()/2, height()/2, 10);
    }		 		 	
	for(int y=0;y<camh;y++){
		if(rendermode==1){
			glBegin(GL_LINES);
		}
		for(int x=0;x<camw;x++){
			float av = 	   ( pix[y*camw*3+x*3+0] + 
							 pix[y*camw*3+x*3+1] + 
							 pix[y*camw*3+x*3+2]   ) / 3.0;
			
			zpos[y*camw+x]+=(av-zpos[y*camw+x])/5.0f;
			
			glPushMatrix();
			if(rendermode==0)glTranslatef(0,0,50-zpos[y*camw+x]);
			glColor3f(
					  pix[y*camw*3+x*3+0]/255.0,
					  pix[y*camw*3+x*3+1]/255.0,
					  pix[y*camw*3+x*3+2]/255.0);
			if(rendermode==0){
				glRectf(x-camw/2,y-camh/2,x+1-camw/2,y+1-camh/2);
			}else if(rendermode==1){
				glVertex3f(x-camw/2,y-camh/2,50-zpos[y*camw+x]);
			}else if(rendermode==2){
				glVertex3f(x-camw/2,y-camh/2,50-zpos[y*camw+x]);
			}else if(rendermode==3){
				glVertex3f(x-camw/2,y-camh/2,50-zpos[y*camw+x]);
			}else if(rendermode==4){
				glVertex3f(x-camw/2,y-camh/2,50-zpos[y*camw+x]);
			}else if(rendermode==5){
				glVertex3f(x-camw/2,y-camh/2,50-zpos[y*camw+x]);
			}else if(rendermode==6){
				glVertex3f(x-camw/2,y-camh/2,50-zpos[y*camw+x]);
			}
			
			glPopMatrix();
		}
		if(rendermode==1){
			glEnd();
		}
		
	}
    if(rendermode==2||rendermode==3||rendermode==4||rendermode==5||rendermode==6){
		glEnd();
    }  
    if(rendermode==6){
		glEnable(GL_BLEND);
    }	
	
}


void _keyDown(int k,int special){
	if(k=='c' && special==0){
		myron->settings();
	}else  if(k=='1' && special==0){
		rendermode = 0;
	}else  if(k=='2' && special==0){
		rendermode = 1;
	}else  if(k=='3' && special==0){
		rendermode = 2;	
	}else  if(k=='4' && special==0){
		rendermode = 3;	
	}else  if(k=='5' && special==0){
		rendermode = 4;	
	}else  if(k=='6' && special==0){
		rendermode = 5;	
	}else  if(k=='7' && special==0){
		rendermode = 6;	
	}
}

void _keyUp(int k,int special){
	
}

void _mouseDown(){
	
}

void _mouseUp(){
	
}

void stop(){
	
}


