#ifndef MAIN_H
#define MAIN_H

  
#define wxUSE_UNICODE 1
#define USE_OWNER_DRAWN 1

//this is for the window sizer cell padding
#define MARGIN 5

#include <wx/wx.h>
#include <wx/textctrl.h>
#include <wx/xml/xml.h>
#include <wx/filedlg.h>
#include <wx/filesys.h>
#include <wx/filename.h>
#include <wx/aboutdlg.h>
#include <wx/utils.h>
#include <wx/colordlg.h>
#include <wx/aui/aui.h>
#include <wx/scrolbar.h>
#include <wx/slider.h>
#include <wx/timer.h>
#include <wx/accel.h>
#include <wx/control.h>
#include <wx/panel.h>
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/glcanvas.h>
#include <wx/checklst.h>
#include <wx/thread.h>
#include <wx/clrpicker.h>
#include <wx/bmpbuttn.h>
#include <wx/bitmap.h>
#include <wx/image.h>
#include <wx/spinctrl.h>
#include <iostream>
#include <deque>
#include <map>
#include <fstream>
#if defined(TARGET_WIN32)
#include <gl/glu.h>
#else
#include <OpenGL/glu.h>
#endif
#include "PerlinNoise.h"
#include "JPoint.h"
#include "tr.h"
#include "gl2ps.h"

using namespace std;

#define ExitCode void*

//------------------------------------------------------------------------------
//for stl::map
struct ltJPoint{
  bool operator()(JPoint p1,JPoint p2) const{
    if(p1.x==p2.x)return p1.y > p2.y;
    else return p1.x > p2.x;
  }
};
//------------------------------------------------------------------------------
enum{
  ID_GL,
  ID_Fullscreen,
  ID_SaveImage,
  ID_SavePDF,
  ID_SavePointList,
  ID_SaveSVG,
  ID_Slider0,
  ID_Slider1,
  ID_Slider2,
  ID_Slider3,
  ID_Slider4,
  ID_Slider5,
  ID_Slider6,
  ID_Slider7,
  ID_BGColor,
  ID_FGColor,
  ID_TileRenderProgress,
};
//------------------------------------------------------------------------------
BEGIN_DECLARE_EVENT_TYPES()
DECLARE_EVENT_TYPE(EVT_STATUS, -1)
END_DECLARE_EVENT_TYPES()
//------------------------------------------------------------------------------
class SaveImageWindow:public wxDialog{
 public:
  SaveImageWindow(wxWindow *parent);
  wxTextCtrl *textWidth;
  wxTextCtrl *textHeight;
  DECLARE_EVENT_TABLE()
};
//------------------------------------------------------------------------------
BEGIN_EVENT_TABLE(SaveImageWindow, wxDialog)
END_EVENT_TABLE()
//------------------------------------------------------------------------------
class MyGLCanvas:public wxGLCanvas{
 public:
  MyGLCanvas(wxWindow*parent,wxWindowID id,const wxPoint& pos,const wxSize& size,long style,const wxString& name,int* attr);
  void OnMousePressed(wxMouseEvent& event);
  void OnMouseReleased(wxMouseEvent& event);
  void OnMouseMoved(wxMouseEvent& event);
  void OnMouseCaptureLost(wxMouseCaptureLostEvent& event);
  DECLARE_EVENT_TABLE()
};
//------------------------------------------------------------------------------
BEGIN_EVENT_TABLE(MyGLCanvas, wxGLCanvas)
EVT_LEFT_DOWN(MyGLCanvas::OnMousePressed)
EVT_LEFT_UP(MyGLCanvas::OnMouseReleased)
EVT_MOTION(MyGLCanvas::OnMouseMoved)
EVT_MOUSE_CAPTURE_LOST(MyGLCanvas::OnMouseCaptureLost)
END_EVENT_TABLE()
//------------------------------------------------------------------------------
class AnimationThread:public wxThread{
 public:
  AnimationThread();
  ExitCode Entry();
};
//------------------------------------------------------------------------------
class MyFrame: public wxFrame{
public:
  MyFrame(const wxString& title, const wxPoint& pos, const wxSize& size);
  void OnQuit(wxCommandEvent& event);
  void OnAbout(wxCommandEvent& event);
  void OnFullscreen(wxCommandEvent& event);
  void OnSize(wxSizeEvent& event);
  void OnClose(wxCloseEvent& event);
  void OnSlider4ThumbTrack(wxScrollEvent& event);
  void OnSlider5ThumbTrack(wxScrollEvent& event);
  void OnSlider6ThumbTrack(wxScrollEvent& event);
  void OnSlider4Changed(wxScrollEvent& event);
  void OnSlider5Changed(wxScrollEvent& event);
  void OnSlider6Changed(wxScrollEvent& event);
  void OnBGColorPressed(wxCommandEvent& event);
  void OnFGColorPressed(wxCommandEvent& event);
  void OnSaveImage(wxCommandEvent& event);
  void OnSavePDF(wxCommandEvent& event);
  void OnSavePointList(wxCommandEvent& event);
  void OnSaveSVG(wxCommandEvent& event);
  void OnSave(wxCommandEvent& event);
  void OnOpen(wxCommandEvent& event);
  void OnStatus(wxCommandEvent& event);
  void status(wxString txt);
  void setImgColor(wxImage& img1,wxColour c);
  void setupGLView(int w,int h);
  void generatePerlins();
  MyGLCanvas *gl;
  deque<wxSlider*> sliders;
  wxPanel *panel1;
  wxPanel *panel2;
  wxAuiManager *auiManager;
  wxCheckBox *checkBox1;
  
  int ticks;
  void draw(int width,int height);
  void update();
  int mouseX;
  int mouseY;
  bool mouseIsDown;
  int pmouseX;
  int pmouseY;
  JPoint viewRotation;
  static MyFrame *instance;
  JPoint *path;
  int pathSize;
  bool pathSizeChanged;
  bool perlinChanged;
  bool perlinSeedChanged;
  float *perlinCache1;
  float *perlinCache2;
  void setBGColor(int r,int g,int b);
  wxColour bgColor;
  wxColour fgColor;
  wxBitmapButton *fgButton;
  wxBitmapButton *bgButton;
  wxSpinCtrl *alphaSpin;
  wxSpinCtrl *lenseSpin;
  wxSpinCtrl *lineSpin;
  DECLARE_EVENT_TABLE()
};
//------------------------------------------------------------------------------
class MyApp: public wxApp{
 public:
  virtual bool OnInit();
  static AnimationThread *animationThread;
};
//------------------------------------------------------------------------------
BEGIN_EVENT_TABLE(MyFrame, wxFrame)
EVT_MENU(wxID_EXIT,MyFrame::OnQuit)
EVT_MENU(wxID_ABOUT,MyFrame::OnAbout)
EVT_MENU(ID_Fullscreen,MyFrame::OnFullscreen)
EVT_MENU(ID_SaveImage,MyFrame::OnSaveImage)
EVT_MENU(ID_SavePDF,MyFrame::OnSavePDF)
EVT_MENU(ID_SavePointList,MyFrame::OnSavePointList)
EVT_MENU(ID_SaveSVG,MyFrame::OnSaveSVG)
EVT_MENU(wxID_SAVE,MyFrame::OnSave)
EVT_MENU(wxID_OPEN,MyFrame::OnOpen)
EVT_SIZE(MyFrame::OnSize)
EVT_CLOSE(MyFrame::OnClose)
EVT_COMMAND_SCROLL_THUMBTRACK(ID_Slider4, MyFrame::OnSlider4ThumbTrack)
EVT_COMMAND_SCROLL_THUMBTRACK(ID_Slider5, MyFrame::OnSlider5ThumbTrack)
EVT_COMMAND_SCROLL_THUMBTRACK(ID_Slider6, MyFrame::OnSlider6ThumbTrack)
EVT_COMMAND_SCROLL_CHANGED(ID_Slider4,MyFrame::OnSlider4Changed)
EVT_COMMAND_SCROLL_CHANGED(ID_Slider5,MyFrame::OnSlider5Changed)
EVT_COMMAND_SCROLL_CHANGED(ID_Slider6,MyFrame::OnSlider6Changed)
EVT_BUTTON(ID_BGColor, MyFrame::OnBGColorPressed)
EVT_BUTTON(ID_FGColor, MyFrame::OnFGColorPressed)
EVT_COMMAND  (wxID_ANY, EVT_STATUS, MyFrame::OnStatus)
END_EVENT_TABLE()
//------------------------------------------------------------------------------
class TileRenderWindow:public wxDialog{
 public:
  TileRenderWindow(wxWindow *parent,int w,int h,wxString fp,float fov);
  ~TileRenderWindow();
  void OnTimer(wxTimerEvent& event);
  void OnClose(wxCloseEvent& event);
  wxStaticText *text;
  wxGauge *gauge;
  wxString filePath;
  int width;
  int height;
  float fovy;
  wxTimer *timer;
  GLubyte *image;
  TRcontext *tr;
  int tileCount;
  int doneTiling;
  DECLARE_EVENT_TABLE()
};
//------------------------------------------------------------------------------
BEGIN_EVENT_TABLE(TileRenderWindow, wxDialog)
EVT_TIMER(wxID_ANY, TileRenderWindow::OnTimer)
EVT_CLOSE(TileRenderWindow::OnClose)
END_EVENT_TABLE()


#endif
