#include "Balloon.h"


Balloon::Balloon(JPoint pnch){
	pinch.copyFrom(pnch);

	JMass::gravity.y = 0;
	int balloon_point_count = ofRandomuf() * 40 + 35;

	//make balloon
	for(int i=0;i<balloon_point_count;i++){
		masses.push_back(new JMass(JPoint(cos(i),sin(i),0)+pinch));
	}
	
	//link balloon surface
	chain = new JChain(0.5);
	for(int i=0;i<balloon_point_count;i++){
		chain->masses.push_back(masses[i]);
	}
	
	color[0] = ofRandomuf();
	color[1] = ofRandomuf();
	color[2] = ofRandomuf();
	color[3] = ofRandomuf();

}


Balloon::~Balloon(){
	delete chain;
}

void Balloon::step(long volume){
	
	
	//find middle
	JPoint averagePos;
	for(int i=0;i<masses.size();i++){
		averagePos+=*masses[i];
	}
	averagePos = averagePos / masses.size();
	
	//step all
	for(int i=0;i<masses.size();i++){
		masses[i]->step();
	}
	
	
	//move away from center
	for(int i=0;i<masses.size();i++){
		JPoint f(averagePos - *masses[i]);
		f.normalizeSelf();
		f = f.invert() * 1;
		masses[i]->applyForce(f);
	}
	

	//keep the first one under control
	masses[0]->force.copyFrom(0,0,0);
	masses[0]->copyFrom(pinch.x,pinch.y,0);
	masses[masses.size()-1]->force.copyFrom(0,0,0);
	masses[masses.size()-1]->copyFrom(pinch.x,pinch.y,0);
	
	//just a little bit of drunk man
	pinch += JPoint(
		ofRandom(-1,1),
		ofRandom(-1,1),
		ofRandom(-1,1)
	);
	
	
	//respond to volume
	float v = volume*0.5;
	pinch += JPoint(
		ofRandom(-v,v),
		ofRandom(-v,v),
		ofRandom(-v,v)
	);
	
	
	chain->step();
	
	
}

