#ifndef _JChain_H_
#define _JChain_H_


#include "JMass.h"
#include <vector>
#include <deque>

using namespace std;


/**
   a physics simulated rope, string, and chain object, built atop
   JMass::springTo() driven by two end points
   @author jtnimoy
*/
class JChain{
 public:
  /**
     how strong is the JChain? this is customarily passed via constructor.
  */
  float strength;

  /**
     a pointer to a JPoint for the head end of the chain
  */
  JPoint *src;

  /**
     a pointer to a JPoint for the tail end of the chain
  */
  
  JPoint *dst;

  /**
     a list of mass pointers to affect
  */
  deque<JMass*> masses;

  /**
     construct a chain using a given list of masses, at a given
     strength
  */
  JChain(deque<JMass*>,float);

  /**
     construct at a given strength, but without populating the JChain
     pointer list
  */
  JChain(float);

  
  ~JChain();
  
  /**
     affect target masses once
  */
  void step();

  /**
     render a GL_LINE_STRIP of all the masses.
  */
  void draw();

};



#endif

