#include "JMass.h"

JPoint JMass::friction(0.99,0.99,0.99);
JPoint JMass::gravity(0,1,0);

void JMass::init(){
  springCount=0;

}

JMass::JMass(float xx,float yy,float zz):JPoint(xx,yy,zz){
  init();
}

JMass::JMass():JPoint(){
  init();
}


JMass::JMass(JPoint p):JPoint(p){
  init();

}

JMass::~JMass(){
  init();

}

void JMass::step(){
  (*this)+=force;
  force+=gravity;
  force*=friction;
}


void JMass::applyForce(JPoint that){
  force += that;
}


void JMass::springTo(JPoint that,float strength){
  applyForce((that-(*this))*strength);
  
}
