#ifndef _JMass_H_
#define _JMass_H_


#include "JPoint.h"
#include <vector>

using namespace std;

/**
   A basic physics mass, subclassing the JPoint. Apply forces and
   stuff to this mass and it will orbit around like a proper screen
   saver.
   @author jtnimoy
 */
class JMass : public JPoint{
 public:

  /**
     a global friction value for all instances of JMass. Yes,
     instance-specific friction with inheritance of global friction is
     a future feature. Someone please implement that :-)
  */
  static JPoint friction;
  
  /**
     a global gravity value for all instances of JMass. Yes,
     instance-specific friction with inheritance of global friction is
     a future feature. Someone please implement that :-)
  */
  static JPoint gravity;

  /**
     internal, called by constructors in order to have a shared memory init routine.
  */
  void init();
  
  /**
     current force state of the object
  */
  JPoint force;


  /**
     empty constructor
  */
  JMass();
  /**
     construct a new mass and pass the position to it already
  */
  JMass(float,float,float);
  
  /**
     construct a new mass and pass the position to it already
  */
  JMass(JPoint);
  
  ~JMass();
  
  /**
     this is a social variable incremented by JSprings when they are
     assigned a JMass to babysit. I forget why this was originally useful.
  */
  int springCount;

  /**
     step the physics forces one time for me
  */
  virtual void step();

  /**
     add some force into the force pool
  */
  void applyForce(JPoint p);

  /**
     spring towards some point, at some give strength
  */
  void springTo(JPoint p,float strength);
};



#endif

