#include "testApp.h"

//--------------------------------------------------------------
void testApp::setup(){	 
	
	ofToggleFullscreen(); //go full screen
	ofEnableSmoothing(); // turn on vector smoothing
	ofEnableAlphaBlending(); // turn on alpha blending
	counter = 0; // initialize counter as 0

	mouseIsDown = false; // initialize mouseIsDown as false

	int bcount = 27; //make 27 balloons
	
	//create the balloons, placing them in the center
	for(int i=0;i<bcount;i++){
		balloons.push_back(new Balloon(JPoint( ofGetWidth()/2 - (bcount/2)*20 + i*20, ofGetHeight()/2 ,0)));
	}
	
	
	//initiate sound
	ofSoundStreamSetup(0,2,this, 44100, 256, 4);	
	left = new float[256];
	right = new float[256];
	bufferCounter = 0;
	volume = 0;

	ticks = 0;
}
//--------------------------------------------------------------
void testApp::audioReceived 	(float * input, int bufferSize, int nChannels){	
	// samples are "interleaved"
	volume = 0;
	for (int i = 0; i < bufferSize; i++){
		left[i] = input[i*2];
		right[i] = input[i*2+1];
		
		//update the volume based on the sound level
		volume += fabs(input[i*2]);
		volume += fabs(input[i*2+1]);
	}
	
	bufferCounter++; //increment buffer count
	
}


//--------------------------------------------------------------
void testApp::update(){
	
	//loop through all the balloons
	for(int i=0;i<balloons.size();i++){
		balloons[i]->step(volume*0.1);//do a physics frame step
		
		//move the center position if the mouse is clicked
		if(mouseIsDown){
			balloons[i]->pinch.lerpSelfTo(JPoint(mouseX,mouseY), 0.1);
		}
	}
	
	counter++; //increment the counter
}

//--------------------------------------------------------------
void testApp::draw(){
	
	//set some colors
	ofBackground(0,0,0);
	ofSetColor(255,255,255);

	//draw the balloons as tesselated contours
	//OF makes this easy to do
	ofBeginShape();
	for(int i=0;i<balloons.size();i++){//for all balloons
		for(int j=0;j<balloons[i]->masses.size();j++){//for all the physics masses
			ofVertex(balloons[i]->masses[j]->x,balloons[i]->masses[j]->y);//lay down a vertex
		}
		ofNextContour();
	}
	ofEndShape();


	//draw them again, but this time with a regular non-tesselated alpha color
	for(int i=0;i<balloons.size();i++){//for all balloons
		glColor4f(balloons[i]->color[0],balloons[i]->color[1],balloons[i]->color[2],balloons[i]->color[3]*0.5);
		ofBeginShape();
		for(int j=0;j<balloons[i]->masses.size();j++){
			ofVertex(balloons[i]->masses[j]->x,balloons[i]->masses[j]->y);
		}
		ofEndShape();
	}

	ticks++;
}

// save a frame to the disk given a filename
void testApp::saveFrame(char *filename){
	ofImage myImage;
	myImage.grabScreen(0,0,ofGetWidth(),ofGetHeight());
	myImage.saveImage(filename);
}


//--------------------------------------------------------------
void testApp::keyPressed  (int key){ 
	if(key=='s'){//user pressed s
		char t[64];//allocate a new string
		sprintf(t,"frame%05i.png",ticks);//put the integer into the string format
		saveFrame(t);//save the image
	}
}

//--------------------------------------------------------------
void testApp::keyReleased  (int key){ 
	
}

//--------------------------------------------------------------
void testApp::mouseMoved(int x, int y ){
}

//--------------------------------------------------------------
void testApp::mouseDragged(int x, int y, int button){
}

//--------------------------------------------------------------
void testApp::mousePressed(int x, int y, int button){
	mouseIsDown = true;
}

//--------------------------------------------------------------
void testApp::mouseReleased(){
	mouseIsDown = false;
}
