#include "Drip.h"
//#include "jttoolkit.h"
//#include "Global.h"
#include "ofMain.h"

namespace grl{
  
	JColor getScreenPixel(int x,int y){
		unsigned char rawpixels[4];
		glReadPixels(x, ofGetHeight()-1-y,1,1, GL_RGB , GL_UNSIGNED_BYTE ,rawpixels);
		return JColor(
						rawpixels[0]/255.0,
						rawpixels[1]/255.0,
						rawpixels[2]/255.0
						);
		
	}
	
	
  Drip::Drip(float x,float y,float z):JPoint(x,y,z){
    length = 0;
    age = 0;
    dead = false;
    JColor c = getScreenPixel(x,y);
    r = c.r;
    g = c.g;
    b = c.b;
  }
  
  Drip::~Drip(){
    
  }
  
  void Drip::step(){
    if(!dead){
      age++;
      if(age<rnd[1]*100)length+=rnd[0]*3+1;
      else dead = true;
    }
  }
  
  void Drip::draw(){
    glBegin(GL_TRIANGLES);
    float pinfat = length*0.01*rnd[3]+0.5;
    glColor();
    (*this+JPoint( pinfat,0,0)).glVertex();
    (*this+JPoint(-pinfat,0,0)).glVertex();
    
    glColor4f(r,g,b,0);

    (*this+JPoint(0,length,0)).glVertex();
    glEnd();
  }
};
