#ifndef _Drip_H_
#define _Drip_H_

#include "JPoint.h"
#include "JColor.h"
#include "FingerPrint.h"

/**
   graffitti research labs classes
*/
namespace grl{
  /**
     a screen-sampling openGL paint drip object for Graffitti Research Labs laser tag brush.
     @author jtnimoy
  */
  class Drip:public JPoint,JColor{ //ya, i'm using multiple inheritence biatch
  public:
    Drip(float x,float y,float z); ///< construct the drip with a given x y z.
    ~Drip();
    void step(); ///< call step once per frame to allow time to drip downward.
    void draw(); ///< gl render myself in position
    float length; ///< the slowly growing length of the drip line.
    FingerPrint rnd; ///< my own personal collection of per-instance persistent randoms.
    float age; ///< for how long have I been instantiated and in memory?
    bool dead; ///< am I dead?
  };
	
	JColor getScreenPixel(int x,int y);

	
}



#endif

