/**
   JPath
   by Josh Nimoy
   for Gabe Dunne
   23 jan 2007
*/

#include "JPath.h"
#include "ofMain.h"
//#include "jttoolkit.h"
//#include "Global.h"


void lights(){
    glEnable(GL_LIGHT0);
    glEnable(GL_LIGHTING);
    glEnable(GL_COLOR_MATERIAL);
}



void nolights(){
    glDisable(GL_LIGHT0);
    glDisable(GL_LIGHTING);
    glDisable(GL_COLOR_MATERIAL);
}



void interpolateBezier(
					   float P0X,float P0Y,float P0Z,
					   float P1X,float P1Y,float P1Z,
					   float P2X,float P2Y,float P2Z,
					   float P3X,float P3Y,float P3Z,
					   int segs,
					   float Xs[] , float Ys[] , float Zs[]) {

    float t=0.0f,dt=1.0f/(float)(segs-1);		// calculating increment
    float Q0X,Q0Y,Q0Z;
    float Q1X,Q1Y,Q1Z;
    float Q2X,Q2Y,Q2Z;
    float R0X,R0Y,R0Z;
    float R1X,R1Y,R1Z;
    float x;float y;float z;
    float xx=P0X;float yy=P0Y;float zz=P0Z;
    for (int i=0;i<segs;i++) {
		Q0X = P0X + t*(P1X-P0X); Q0Y = P0Y + t*(P1Y-P0Y); Q0Z = P0Z + t*(P1Z-P0Z);
		Q1X = P1X + t*(P2X-P1X); Q1Y = P1Y + t*(P2Y-P1Y); Q1Z = P1Z + t*(P2Z-P1Z);
		Q2X = P2X + t*(P3X-P2X); Q2Y = P2Y + t*(P3Y-P2Y); Q2Z = P2Z + t*(P3Z-P2Z);
		R0X = Q0X + t*(Q1X-Q0X); R0Y = Q0Y + t*(Q1Y-Q0Y); R0Z = Q0Z + t*(Q1Z-Q0Z);
		R1X = Q1X + t*(Q2X-Q1X); R1Y = Q1Y + t*(Q2Y-Q1Y); R1Z = Q1Z + t*(Q2Z-Q1Z);
		x = R0X + t*(R1X-R0X);
		y = R0Y + t*(R1Y-R0Y);
		z = R0Z + t*(R1Z-R0Z);
		//drawLine(xx,yy,zz,x,y,z);
		Xs[i]=x;
		Ys[i]=y;
		Zs[i]=z;
		xx=x;
		yy=y;
		zz=z;
		t+=dt;
    }
}



JPath::JPath(JPath *mentor){
  JPath(mentor->points);
}


JPath::JPath(){
  resetVars();
}

JPath::JPath(deque<JPoint*>p){
  resetVars();

  //make a deep copy of that vector
  deque<JPoint*>::iterator it;
  for(it=p.begin();it!=p.end();it++){
    points.push_back(new JPoint(**it));
  }
}

JPath::JPath(vector<JPoint*>p){
  resetVars();

  //make a deep copy of that vector
  vector<JPoint*>::iterator it;
  for(it=p.begin();it!=p.end();it++){
    points.push_back(new JPoint(**it));
  }
}



void JPath::resetVars(){
  stroke_width = 1.5;
  useInnerFill = true;
  useOutline = false;
  stroke_flare = 10;
  stroke_style = 0;
}


void JPath::fromBezier(JPoint p1,JPoint p2,JPoint p3,JPoint p4,int steps){

  // allocate some working space.
  float *Xs = new float[steps];
  float *Ys = new float[steps];
  float *Zs = new float[steps];

  interpolateBezier(
		    p1.x,p1.y,p1.z,
		    p2.x,p2.y,p2.z,
		    p3.x,p3.y,p3.z,
		    p4.x,p4.y,p4.z,
		    steps,Xs,Ys,Zs) ;


  points.push_back(new JPoint(p1));
  for(int i=1;i<steps-1;i++){
    points.push_back(new JPoint(Xs[i],Ys[i],Zs[i]));
  }
  points.push_back(new JPoint(p4));


  delete Xs;
  delete Ys;
  delete Zs;

}




JPath::~JPath(){
  deque<JPoint*>::iterator it;
  for(it=points.begin();it!=points.end();it++){
    delete *it;
  }

}

/**
   divide all edges in 2.
*/
void JPath::subdiv(){
  deque<JPoint*>dest;


  deque<JPoint*>::iterator it;
  int i=0;
  for(it=points.begin();it!=points.end();it++){
    dest.push_back(*it);
    if(i<points.size()-1){//don't add one for the last
      dest.push_back(new JPoint( (*it)->lerpTo(**(it+1),0.5)    ));
    }
    i++;
  }





  //ok, now copy dest back into points
  points.clear();
  for(it=dest.begin();it!=dest.end();it++){
    points.push_back(*it);
  }

}


/**
   loop through all the verts and call glVertex3f(x,y,z);
*/
void JPath::glVertex(){
  deque<JPoint*>::iterator it;
  for(it=points.begin();it!=points.end();it++){
    (*it)->glVertex();
  }

}


/*
  lerping towards the previous and next points, we are effectively
  melting the geometry toward the center.
*/
void JPath::melt(float heat){
  //draw handles

  deque<JPoint*>::iterator it;
  int i=0;
  for(it=points.begin();it!=points.end();it++){


    JPoint *curr = *it;
    JPoint *prev;
    JPoint *next;

    if(i>0)prev=*(it-1);
    else   prev=curr;

    if(i<points.size()-1)next=*(it+1);
    else   next=curr;

    curr->lerpSelfTo(*prev,heat);
    curr->lerpSelfTo(*next,heat);

    i++;//keep this close to the end curly bracket.
  }
}

void JPath::smooth(int val){
  for(int i=0;i<val;i++){
    subdiv();
    melt(0.5);
  }
}

void JPath::println(){

  cout << "JPath( ";
  deque<JPoint*>::iterator it;
  for(it=points.begin();it!=points.end();it++){
    JPoint *t = *it;
    cout << "JPoint(" << t->x << ' ' << t->y << ' ' << t->z << ") ";
  }
  cout << " ) " << endl;
}

void JPath::render(){
  deque<JPoint*>::iterator it;
  glBegin(GL_LINE_STRIP);
  for(it=points.begin();it!=points.end();it++){
    (**it).glVertex();
  }
  glEnd();
}

void JPath::reset(){
  //kill the entire memory.
  while(points.size()>0){
    delete points.back();
    points.pop_back();
  }
}

void JPath::renderAsBezier(int steps){
  JPath p;
  p.fromBezier(*points[0],*points[1],*points[2],*points[3],steps);
  p.render();
}


void JPath::stroke(int steps,bool bez=false){
  if(points.size()<2)return;
  deque<JPoint*>::iterator it;
  JPath *p;
  if(bez){
    p = new JPath();
    p->fromBezier(*points[0],*points[1],*points[2],*points[3],steps);
  }else p = new JPath(points);

  deque<JPoint>row1;
  deque<JPoint>row2;
  deque<JPoint>row3;

  int i=0;
  for(it=p->points.begin();it!=p->points.end();it++){
    JPoint p1;
    JPoint p2;
    JPoint p3;
    JPoint p4;

    if(i==0){//beginning case
      p1.copyFrom(**(it));
      p2.copyFrom(**(it+1));
      p3.copyFrom(p2);
      p4.copyFrom(p2);
      p3.rotateSelfZ( PI/2,p1);
      p4.rotateSelfZ(-PI/2,p1);
    }else if(i==points.size()-1){//end case
      p1.copyFrom(**(it-1));
      p2.copyFrom(**(it));
      p3.copyFrom(p1);
      p4.copyFrom(p1);
      p3.rotateSelfZ(-PI/2,p2);
      p4.rotateSelfZ( PI/2,p2);
    }else{//in the middle, we average the angles.
      p1.copyFrom(**(it-1));
      p2.copyFrom(**(it));
      p3.copyFrom(p1);
      p4.copyFrom(p1);
      p3.rotateSelfZ(-PI/2,p2);
      p4.rotateSelfZ( PI/2,p2);

      //calculate averagables
      JPoint p5(p1);
      JPoint p6(p1);
      p5.rotateSelfZ(-PI/2,p2);
      p6.rotateSelfZ( PI/2,p2);
      p3.lerpSelfTo(p5,0.5);
      p4.lerpSelfTo(p6,0.5);
    }
    //accumilate the results for later.
    row1.push_back(JPoint(p3));
    row2.push_front(JPoint(p4));
    row3.push_back(JPoint(**it));

    ////normalise the outstretches away from the skel.
    //row1.back().normalizeSelfFrom(row3.back(),10);
    //row2.front().normalizeSelfFrom(row3.back(),10);
    i++;
  }
  delete p;

  //MASSAGE THE SHAPE
  for(int i=0;i<row1.size();i++){
    int ii = row1.size()-1-i;


    //  >>===---===<<
    //float fatness1 = stroke_width*2-pow((stroke_width*(float)i)/row1.size() * (stroke_width*(float)ii)/row1.size(),2);
    float fatness1 = stroke_width*stroke_flare -
      (stroke_width* ((float)i/row1.size() * (stroke_width*(float)ii)/row1.size()));



    //   ---==+++==--
    float fatness2 = (stroke_width*(float)i)/row1.size() * (stroke_width*(float)ii)/row1.size();
    float fatness3 = row1[i].distanceFrom( row2[row2.size()-1-i-1]);


    float fatness;
    if(stroke_style==0){
      fatness = fatness1*points.size();
    }else if(stroke_style==1){
      fatness = fatness3*points.size()*0.001;
    }else{
      float p =points.size()*0.1;
      fatness =  fmax(1,(stroke_width*100 - fmin(stroke_width*100 ,fatness3*2)))*0.5;
    }


    row1[ i].normalizeSelfFrom(row3[i],fatness);
    row2[ii].normalizeSelfFrom(row3[i],fatness);

    //magnets to buckle down the edges
  }

  //draw buff

  if(useInnerFill){
    glBegin(GL_TRIANGLE_STRIP);
    for(int i=0;i<row2.size();i++){
      row2[row2.size()-1-i].glVertex();
      row1[i].glVertex();
    }
    glEnd();
  }


  if(useOutline){
    glBegin(GL_LINE_LOOP);
    for(int i=0;i<row1.size();i++)row1[i].glVertex();
    for(int i=0;i<row2.size();i++)row2[i].glVertex();
    glEnd();
  }


  /*
  //draw ladder spokes.
  glBegin(GL_LINES);
  for(int i=0;i<row1.size();i++){
    int ii = row1.size()-1-i;
    row1[ i].glVertex();
    row2[ii].glVertex();
  }
  glEnd();
  */

  //draw middle skeleton
  /*
  glBegin(GL_LINE_STRIP);
  for(int i=0;i<row3.size();i++){
    row3[i].glVertex();
  }
  glEnd();
  */

}


void JPath::drink(FingerPoints f, int offset){
  deque<JPoint*>::iterator it;
  int i=0;
  for(it=points.begin();it!=points.end();it++){
    (**it)+=f[offset+i];
    i++;
  }
}



JPoint JPath::average(){
  JPoint accum;
  deque<JPoint*>::iterator it;
  for(it=points.begin();it!=points.end();it++){
    accum+=(**it);
  }
  return accum/(float)points.size();
}


void JPath::shrink(float v){
  JPoint accum;
  JPoint a = average();
  deque<JPoint*>::iterator it;
  for(it=points.begin();it!=points.end();it++){
    (**it).lerpSelfTo(a,v);
  }

}

void JPath::operator+=(JPoint p){
  deque<JPoint*>::iterator it;
  for(it=points.begin();it!=points.end();it++){
    (**it)+=p;
  }
}

void JPath::operator*=(JPoint p){
  deque<JPoint*>::iterator it;
  for(it=points.begin();it!=points.end();it++){
    (**it)*=p;
  }
}


void JPath::eatPointsFromBothEnds(int bites){
  for(int i=0;i<bites;i++){

    if(points.size()>0){
      delete (JPoint*)points.front();
      points.pop_front();
    }

    if(points.size()>0){
      delete (JPoint*)points.back();
      points.pop_back();
    }

  }
}


void JPath::extrudePsychedelic(){
  lights();
  glBegin(GL_TRIANGLE_STRIP);
  float rad = stroke_width*0.4*points.size();
  float s = 316*0.01;
  deque<JPoint*>::iterator it;
  int i=0;

  for(it=points.begin();it!=points.end();it++){
    JPoint p(**it);
    p+=JPoint(cos(i*s)*rad,0,sin(i*s)*rad);
    if(i>0){
      JPoint pp(p-**(it-1));
      glNormal3f(pp.x,pp.y,pp.z);
    }

    p.glVertex();
    i++;
  }

  glEnd();
  nolights();
}
