

#ifndef _JPath_H_
#define _JPath_H_

#include "JPoint.h"
#include <vector>
#include <deque>
#include "FingerPrint.h"
#include "FingerPoints.h"

using namespace std;

/**
   JPath is a rendering helper class for managing lists of points
   @author Josh Nimoy
   for Gabe Dunne
   23 jan 2007

   may 2007 - added funky shit for GRL
*/
class JPath{
 public:
  float stroke_width; ///< change this to tell stroke() how fat to go.
  FingerPrint rnd; ///< my own personal randoms in case i need them
  deque<JPoint*>points;///< my internal JPoint list
  JPath(); ///< construct me empty but don't expect anything to render until you've pushed some points in.
  JPath(JPath *mentor); ///< construct a new jpath and copy jpoints from another path.
  JPath(vector<JPoint*>); ///< construct a new jpath copying this list of points.
  JPath(deque<JPoint*>); ///< construct a new jpath copying this list of points.
  ~JPath();
  void melt(float heat); ///< lerp each points closer to one another. Pass 0.5 for the most melting action.
  void subdiv();///< divide each segment into two.
  void glVertex();///< convenience function that loops through the points and calls glVertex for you. One more hidden for loop for you not to write.
  void fromBezier(JPoint p1,JPoint p2,JPoint p3,JPoint p4,int steps); ///< construct a path from bezier handles.
  void smooth(int val); ///< my favourite function of 2007. Higher level call than melt and subdiv.
  void println(); ///< cout wrapper. nough said.
  void render(); ///< draw a gl line
  void renderAsBezier(int steps); ///< use the points as bezier handles and do a gl line strip.
  void stroke(int steps,bool bez); ///< a rather large function that makes a wormy looking thing. Not exactly reusable. Tweak at will. Please mind my alchemy.
  void reset(); ///< reset the state machine for the stroke function and clear the points vector.
  void drink(FingerPoints f, int offset); ///< do a drunk man on all the points.
  void shrink(float v); ///< go towards the calculated middle by some amount - way non-reusable.
  JPoint average(); ///< average the points out and return one single point.
  
  void operator+=(JPoint p);
  void operator*=(JPoint p);
  
  void resetVars(); ///< reset ONLY the finite state machine vars.

  bool useInnerFill; ///< fill the stroke like it's a solid snake.
  bool useOutline; ///< outline the snake with its own gl line outline.
  
  void eatPointsFromBothEnds(int bites); ///< make the snake shorter.

  float stroke_flare; ///< how much to flare out the stroke
  int stroke_style; ///< 0 or 1 for now. not really planned.

  void extrudePsychedelic(); ///< sort of that 3D lighting normal trick - implemented specifically for GRL graffitti brush.
  
};



#endif

