#include "testApp.h"


void hideMouse(){
#ifndef TARGET_WIN32
	HideCursor();
#else
    ShowCursor(false);
#endif
}


void showMouse(){
#ifndef TARGET_WIN32
	ShowCursor();
#else
    ShowCursor(true);
#endif
}


//--------------------------------------------------------------
void testApp::setup(){

	ofToggleFullscreen();

	ofEnableSmoothing();
	ofEnableAlphaBlending();

	buttonSize = 32;
	buttonTicks = -1000;

	hideMouse();

	cursorVisible = false;
	ticks=0;
	mouseIsDown = false;
	breakWait = 1000;
	lastMouseUpTime = 0;

	resetAndShuffle();

	drips_max = 2000;
	canvasDirty = false;

	blots.push_back(new ofImage());
	blots.back()->loadImage("media/blots/00.png");
	blots.push_back(new ofImage());
	blots.back()->loadImage("media/blots/01.png");
	blots.push_back(new ofImage());
	blots.back()->loadImage("media/blots/02.png");
	blots.push_back(new ofImage());
	blots.back()->loadImage("media/blots/03.png");
	blots.push_back(new ofImage());
	blots.back()->loadImage("media/blots/04.png");
	blots.push_back(new ofImage());
	blots.back()->loadImage("media/blots/05.png");
	blots.push_back(new ofImage());
	blots.back()->loadImage("media/blots/06.png");
	blots.push_back(new ofImage());
	blots.back()->loadImage("media/blots/07.png");
	blots.push_back(new ofImage());
	blots.back()->loadImage("media/blots/08.png");
	blots.push_back(new ofImage());
	blots.back()->loadImage("media/blots/09.png");

	stars.push_back(new ofImage());
	blots.back()->loadImage("media/stars/00.png");
	stars.push_back(new ofImage());
	blots.back()->loadImage("media/stars/01.png");
	stars.push_back(new ofImage());
	blots.back()->loadImage("media/stars/02.png");
	stars.push_back(new ofImage());
	blots.back()->loadImage("media/stars/03.png");
	stars.push_back(new ofImage());
	blots.back()->loadImage("media/stars/04.png");
	stars.push_back(new ofImage());
	blots.back()->loadImage("media/stars/05.png");
	stars.push_back(new ofImage());
	blots.back()->loadImage("media/stars/06.png");
	stars.push_back(new ofImage());
	blots.back()->loadImage("media/stars/07.png");
	stars.push_back(new ofImage());
	blots.back()->loadImage("media/stars/08.png");
	stars.push_back(new ofImage());
	blots.back()->loadImage("media/stars/09.png");


}

void testApp::resetAndShuffle(){
    //DELETE ALL PATHS
    int s = paths.size();
    for(int i=0;i<s;i++){
		delete (JPath*)paths.back();
		paths.pop_back();
    }

    //choose another style
    rgb.reset();
    rnd.vals.clear();
    //massage nature a bit
    rgb[0].contrast(0.4);
    rgb[1].contrast(0.4);
    rgb[2].contrast(0.4);

    killAllDrops();
	canvasDirty = false;
}

void testApp::killAllDrops(){
	//kill all drips
	int s = drips.size();
	for(int i=0;i<s;i++){
		delete (Drip*)drips.back();
		drips.pop_back();
	}
}


//--------------------------------------------------------------
void testApp::update(){

}

//--------------------------------------------------------------
void testApp::draw(){
	//glClearColor(0,0,0,0);
	ofBackground(0,0,0);


	//adding new vertices to the current path
	if(mouseIsDown){
		paths.back()->points.push_back(new JPoint(mouseX,mouseY));
	}

	//rendering the paths
	deque<JPath*>::reverse_iterator it;
	deque<JPath*>::iterator fit;

	//draw global outline first
	for(it=paths.rbegin();it!=paths.rend();it++){
		JPath p((*it)->points);
		p.smooth(4);
		p.melt(0.5);
		p.melt(0.5);
		glColor4f(rgb[0].r,rgb[0].g,rgb[0].b,rnd[50]);
		p.stroke_width = 0.5;
		p.stroke_flare = 0.5;
		if(rnd[67]>0.5)p.stroke_style = 2;
		p.stroke(0,0);
	}


	//then draw the individual contours with local outlines
	for(it=paths.rbegin();it!=paths.rend();it++){
		JPath p((*it)->points);
		p.smooth(4);

		glColor4f(rgb[1].r,rgb[1].g,rgb[1].b,1);
		p.stroke_width = 0.4;
		p.stroke_flare = 0.4;
		p.eatPointsFromBothEnds(8);

		if(rnd[1]>0.5){
			p.stroke_style = 2;
			p.stroke(0,0);
		}else p.extrudePsychedelic();

		glColor4f(1,0.78,0.9,1);
		p+=JPoint(9,9,0);
		p.stroke_width = 0.3;
		p.stroke_flare = 0.3;
		//p.eatPointsFromBothEnds();
		glColor4f(rgb[2].r,rgb[2].g,rgb[2].b,0.8);


		if(rnd[0]>0.5){
			p.stroke_style = 2;//change to the worm
			p.stroke(0,0);
		}else p.extrudePsychedelic();

	}


	float white_probability = 0.95;


	//render fluff on own layer
	int i=0;

	for(fit=paths.begin();fit!=paths.end();fit++){

        if((**fit).points.size()>0){

            float s = 2;
            JColor c1 = getScreenPixel(
                                         (**fit).points.back()->x,
                                         (**fit).points.back()->y
                                         );
            JColor c2 = getScreenPixel(
                                         (**fit).points.front()->x,
                                         (**fit).points.front()->y
                                         );
            glPushMatrix();
            (**fit).points.back()->glTranslate();
            glScalef(rnd[i*100+0]*s,rnd[i*100+0]*s,rnd[i*100+0]*s);
            glTranslatef(-128,-128,0);
            if(i!=0){

                if(rnd[i*100+12]>white_probability)glColor4f(1,1,white_probability,rnd[i*100+2]);
                else glColor4f(c1.r,c1.g,c1.b,rnd[i*100+2]);
                blots[rnd[i*100+5]*(blots.size()-1)]->draw(0,0);
                if(rnd[i*100+10]>white_probability)glColor4f(1,1,white_probability,rnd[i*100+9]);
                else glColor4f(c1.r,c1.g,c1.b,rnd[i*100+9]);
                stars[rnd[i*100+5]*(stars.size()-1)]->draw(0,0);

            }
            glPopMatrix();

            glPushMatrix();
            (**fit).points.front()->glTranslate();

            glScalef(rnd[i*100+1]*s,rnd[i*100+1]*s,rnd[i*100+1]*s);
            glTranslatef(-128,-128,0);
            if(rnd[i*100+13]>white_probability)glColor4f(1,1,white_probability,rnd[i*100+3]);
            else glColor4f(c2.r,c2.g,c2.b,rnd[i*100+3]);
            blots[rnd[i*100+6]*(blots.size()-1)]->draw(0,0);
            if(rnd[i*100+11]>white_probability)glColor4f(1,1,white_probability,rnd[i*100+10]);
            else glColor4f(c2.r,c2.g,c2.b,rnd[i*100+10]);
            stars[rnd[i*100+5]*(stars.size()-1)]->draw(0,0);

            glPopMatrix();
        }
		i++;
	}


	//babysitting those drips
	deque<Drip*>::iterator drip_it;
	for(drip_it = drips.begin() ; drip_it != drips.end() ; drip_it++ ){
		(*drip_it)->step();
	}

	for(drip_it = drips.begin() ; drip_it != drips.end() ; drip_it++ ){
		(*drip_it)->draw();
	}

	//make a new drip?
	int safety_counter = 0;
	if(ofRandomuf()>0.1 && drips.size()<drips_max){
	do_over:
		float x = ofRandomuf()*ofGetWidth();
		float y = ofRandomuf()*ofGetHeight();
		float z = 0;
		JColor c = getScreenPixel(x,y);
		if( canvasDirty && !mouseIsDown && (c.r!=0 || c.g!=0 || c.b!=0 )){//make sure not to drip the background.
			drips.push_back(new Drip(x,y,z));
		}else{
			safety_counter++;
			if(safety_counter<100)goto do_over;
		}
	}

	//draw button on the bottom left hand corner
	if(ticks - buttonTicks > 10){
		ofNoFill();
	}else{
		float a = (1.0 - (ticks - buttonTicks)/10.0)*255.0;
		ofFill();
		ofSetColor(a,a,a);
	}
	ofCircle(buttonSize, ofGetHeight() - buttonSize,buttonSize);
	ofNoFill();
	ofSetColor(255,255,255);
	ofCircle(buttonSize, ofGetHeight() - buttonSize,buttonSize);


	ticks++;
}

//--------------------------------------------------------------
void testApp::keyPressed  (int key){
	if(key==' '){
		resetAndShuffle();
	}

	if(key=='m'){
		cursorVisible = !cursorVisible;
		if(cursorVisible)showMouse();
		else hideMouse();
	}

}

//--------------------------------------------------------------
void testApp::keyReleased  (int key){

}

//--------------------------------------------------------------
void testApp::mouseMoved(int x, int y ){
}

//--------------------------------------------------------------
void testApp::mouseDragged(int x, int y, int button){
}

//--------------------------------------------------------------
void testApp::mousePressed(int x, int y, int button){

	if(mouseX < buttonSize*2 && mouseY > ofGetHeight() - buttonSize*2){
		resetAndShuffle();
		buttonTicks = ticks;
	}else{

		killAllDrops();
		paths.push_back(new JPath());//start a new path
		mouseIsDown = true;
		canvasDirty = true;
	}
}

//--------------------------------------------------------------
void testApp::mouseReleased(){
	mouseIsDown = false;
	lastMouseUpTime = ticks;
}
