#ifndef _TEST_APP
#define _TEST_APP

#include <deque>
#include "JPath.h"
#include "Drip.h"
#include "ColorFingerPrint.h"
#include "FingerPrint.h"
#include "FingerPoints.h"

using namespace std;
using namespace grl;

#include "ofMain.h"
//#include "ofAddons.h"

class testApp : public ofSimpleApp{

	public:

		void setup();
		void update();
		void draw();

		void keyPressed(int key);
		void keyReleased(int key);
		void mouseMoved(int x, int y );
		void mouseDragged(int x, int y, int button);
		void mousePressed(int x, int y, int button);
		void mouseReleased();


		/**
		 a list of graffitti screen drips that exist somewhat indifferenty
		 to the drawn vector geometries. They just sample the screen and
		 do their jobs.
		 */
		deque<Drip*> drips;

		/**
		 a list of paths drawn by each mouse drag event.
		 */
		deque<JPath*> paths;

		bool mouseIsDown; ///< i want to keep track of whether or not the mouse is down.
		int breakWait; ///< how long to wait before breaking away - i'm not sure if this is quite working yet.
		int lastMouseUpTime; ///< time since the last mouseup event.

		ColorFingerPrint rgb; ///< my collection of self-providing persistent random colors.
		int drips_max; ///< how many drips on the screen at most?
		void resetAndShuffle(); ///< change the brush.
		FingerPrint rnd; ///< my collection of self-providing persistent random floated values between 0 and 1.
		FingerPoints rndpoints; ///< my collection of self-providing persistent random jpoints.
		deque<ofImage*> blots; ///< a flat pool of little spray blots.
		deque<ofImage*> stars; ///< a flat pool of little spray stars.
		void killAllDrops(); ///< deallocate all drips.
		int ticks;
		bool cursorVisible;
		float buttonSize;
		int buttonTicks;
		bool canvasDirty;
};

#endif

