//
// WRITTEN BY JOSH NIMOY, AUG 2001, for Victoria Vesna, SINAPSE
// 
// If you use this code, I'm interested in knowing what you use it for.
// Please drop me a line - jtnimoy@ucla.edu or nimoy@media.mit.edu
//
//

import java.awt.*;

public class CentralizedNetwork{

	public int MAX_LINES = 75;

	public int STATE_DRAWING= 0;
	public int STATE_COOLING = 1;
	public int STATE_READY = 2;
	public int STATE_DISABLED = 3;
	
	public sinapseSplash ss;
	public NimoyGL ngl;
	public UCLA ucla;

	public int targetBuildings[];
	public int lineCount=0;
	public DestColor networkColor;
	public DestColor drawColor;

	public int state = STATE_READY;

	public int drawing_inc = 0;
	public int segs = 12;

	public int lightR = 220;
	public int lightG = 255;
	public int lightB = 140;

	public int darkR = 100;
	public int darkG = 150;
	public int darkB = 90;


	public int retract = segs;

	public CentralizedNetwork(sinapseSplash s){
		ss=s;
		ngl = s.ngl;
		ucla = s.ucla;
		networkColor = new DestColor(0,0,0,darkR,darkG,darkB,3.0f);
		drawColor = new DestColor(255,0,0,255,0,0,3.0f);
		targetBuildings = new int[MAX_LINES];
	}

	public void paint(){
		if(retract>0){
			float ox=1500;
			float oy=1000;
			ngl.setColor(networkColor.getColor());
			float x;
			float y;
			float d;
			//draw all of the connections
			ngl.pushMatrix();
			for(int i=0;i<lineCount;i++){
				x = ucla.buildings[targetBuildings[i]].midPoint.x+
					ucla.buildings[targetBuildings[i]].curTranslation.x;
				y = ucla.buildings[targetBuildings[i]].midPoint.y+
					ucla.buildings[targetBuildings[i]].curTranslation.y;
				d = (float)Math.sqrt((ox-x)*(ox-x) + (oy-y)*(oy-y))/2.0f;
				if(i==lineCount-1&&(state==STATE_DRAWING||state==STATE_COOLING)){
					if(!ss.mouseInBorder)ngl.setColor(drawColor.getColor());
					ngl.drawBezier(ox,oy,0,ox,oy,d,x,y,d,x,y,0,segs,drawing_inc);
					ngl.setColor(networkColor.getColor());
				}
				else ngl.drawBezier(ox,oy,0,ox,oy,d,x,y,d,x,y,0,segs,retract);
			}
			ngl.popMatrix();
		}

	}

	public void frame(){

		networkColor.frame();
		drawColor.frame();
		if(!ss.mouseInBorder){

			if(state==STATE_READY){
				if(lineCount<MAX_LINES){
					if(Math.random()>0.9){
						//choose a new building at random
						int c = (int)(Math.random()*150);
						while(alreadyInPool(c))
							c = (int)(Math.random()*150);
						//add it to the pool
						targetBuildings[lineCount++]=c;
						state = STATE_DRAWING;
						drawColor.setDest(255,0,0,1.0f);
						drawing_inc = 0;
					}
						
				}
			}

			if(state==STATE_DRAWING){
				if(++drawing_inc==segs){
					state=STATE_COOLING;
					drawColor.setDest(darkR,darkG,darkB,10.0f);
				}
			}


			if(state==STATE_COOLING){
				if(drawColor.settled()){
					state=STATE_READY;
				}
			}

			if(state==STATE_DISABLED){
				if(retract>0)retract--;
			}

		}
	}

	public void enable(){
		lineCount = 0;
		retract = segs;
		state=STATE_READY;
	}

	
	public void disable(){
		state=STATE_DISABLED;
	}



	public boolean alreadyInPool(int c){
		//checks if an indexed building is already targetted
		boolean foundOne = false;
		for(int i=0;i<lineCount;i++){
			if(targetBuildings[i]==c)return true;
		}
		return false;
	}

	public void borderMouseLeave(){
		networkColor.setDest(darkR,darkG,darkB,7.0f);
		if(state==STATE_COOLING)drawColor.setDest(darkR,darkG,darkB,5.0f);
		if(state==STATE_DRAWING)drawColor.setDest(255,0,0,5.0f);
	}

	public void borderMouseEnter(){
		networkColor.setDest(lightR,lightG,lightB,5.0f);
		drawColor.setDest(lightR,lightG,lightB,5.0f);
	}


}


