//
// WRITTEN BY JOSH NIMOY, AUG 2001, for Victoria Vesna, SINAPSE
// 
// If you use this code, I'm interested in knowing what you use it for.
// Please drop me a line - jtnimoy@ucla.edu or nimoy@media.mit.edu
//
//

import java.awt.*;

public class DecentralizedNetwork{

	public int MAX_BOTTOM_NODES = 75;

	public int STATE_DRAWING= 0;
	public int STATE_COOLING = 1;
	public int STATE_READY = 2;
	public int STATE_DISABLED = 3;
	
	public sinapseSplash ss;
	public NimoyGL ngl;
	public UCLA ucla;

	public int lineCount=0;
	public DestColor networkColor;
	public DestColor drawColor;

	public int state = STATE_READY;

	public int drawing_inc = 0;
	public int segs = 12;

	public int lightR = 255;
	public int lightG = 230;
	public int lightB = 230;

	public int darkR = 170;
	public int darkG = 130;
	public int darkB = 110;

	public Node bottomNodes[];
	public Node middleNodes[];

	public int retract = segs;

	public int nodesEnabled=0;

	public Vector3D topPoint;

	public float stickFlow = 10.0f;

	public DecentralizedNetwork(sinapseSplash s){
		ss=s;
		ngl = s.ngl;
		ucla = s.ucla;
		networkColor = new DestColor(0,0,0,darkR,darkG,darkB,3.0f);
		drawColor = new DestColor(255,0,0,255,0,0,3.0f);
		bottomNodes = new Node[MAX_BOTTOM_NODES];
		middleNodes = new Node[MAX_BOTTOM_NODES];
		topPoint = new Vector3D(1000.0f,1000.0f,-600.0f);
		calculateNodes();
		AverageNodePositions();
	}

	public void paint(){
		boolean foundEnabledBuilding = false;
		boolean foundEnabledBNode = false;
		if(retract>0){
			float d;
			boolean foundOne = false;
			ngl.setColor(networkColor.getColor());

			ngl.pushMatrix();
			//draw all of the connections
			for(int i=0;i<MAX_BOTTOM_NODES;i++){
				if(middleNodes[i].childCount>0){
					foundEnabledBNode=false;
					//now draw its bottom-node-children
					for(int ii=0;ii<middleNodes[i].childCount;ii++){
						Node thisb = bottomNodes[middleNodes[i].children[ii]];
						
						//now draw that child's building connections
						foundEnabledBuilding=false;
						for(int iii=0;iii<thisb.childCount;iii++){
							if(thisb.enabled){
								ngl.drawLine(thisb.pos,
								ucla.buildings[thisb.children[iii]].getMidpointWithCurTranslation());
								foundEnabledBuilding=true;
							}
						}
						if(foundEnabledBuilding){
							ngl.drawLine(middleNodes[i].pos,thisb.pos);
							foundEnabledBNode=true;
						}
					}
					if(foundEnabledBNode)ngl.drawLine(topPoint,middleNodes[i].pos);
				}
			}
			ngl.popMatrix();

		}
		
		

	}

	public void frame(){

		AverageNodePositions();
		networkColor.frame();
		
		drawColor.frame();
		
		if(!ss.mouseInBorder){

			if(state==STATE_READY){
				//enabled another
				if(nodesEnabled<MAX_BOTTOM_NODES){
					if(Math.random()>.95){
						int r = (int)((Math.random()*MAX_BOTTOM_NODES));
						while(bottomNodes[r].enabled)
							r = (int)((Math.random()*MAX_BOTTOM_NODES));
						bottomNodes[r].enabled=true;
						nodesEnabled++;
					}
				}

			}

			if(state==STATE_DISABLED){
				//if(retract>0)retract--;
				for(int i=0;i<MAX_BOTTOM_NODES;i++){
					middleNodes[i].enabled = false;
				}
				for(int i=0;i<MAX_BOTTOM_NODES;i++){
					if(bottomNodes[i].enabled){
						bottomNodes[i].enabled=false;
						nodesEnabled--;
						break;
					}
				}

			}

		}
	}

	public void enable(){
		state=STATE_READY;
		stickFlow = 10.0f;
		calculateNodes();
		
	}
	
	public void disable(){
		state=STATE_DISABLED;
		stickFlow = 3.0f;
	}

	public void AverageNodePositions(){
		//straighten out the connections
		//first the bottom nodes, according to their buildings.

		//ignore disabled nodes
		//setting emabled/disabled of MNodes here
		Vector3D temp;
		Node tempNode;
		
		float x;
		float y;
		int cx;

		boolean BNodeActive=false;

		for(int i=0;i<MAX_BOTTOM_NODES;i++){
			
			if(middleNodes[i].childCount>0){
				BNodeActive=false;
				for(int ii=0;ii<middleNodes[i].childCount;ii++){//also checking if any bottoms are enabled
					tempNode = bottomNodes[middleNodes[i].children[ii]];
					if(tempNode.enabled){//then actually calculate it
						x = 0;
						y = 0;
						cx = 0;
						for(int iii=0;iii<tempNode.childCount;iii++){
							temp = ucla.buildings[tempNode.children[iii]].getMidpointWithCurTranslation();
							x+=temp.x;
							y+=temp.y;
							cx++;
						}
						if(cx>0){
							x/=cx;
							y/=cx;

							tempNode.pos.x+=(x-tempNode.pos.x)/stickFlow;
							tempNode.pos.y+=(y-tempNode.pos.y)/stickFlow;
						}
						BNodeActive=true;
					}
				}
				if(BNodeActive)middleNodes[i].enabled=true;
			}
			
		}

		//next we do the middle nodes, according to their bottom nodes
		for(int i=0;i<MAX_BOTTOM_NODES;i++){
			if(middleNodes[i].childCount>0 && middleNodes[i].enabled){
				x = 0;
				y = 0;
				cx = 0;
				
				for(int ii=0;ii<middleNodes[i].childCount;ii++){
					tempNode = bottomNodes[middleNodes[i].children[ii]];
					if(tempNode.enabled){
						x += tempNode.pos.x;
						y += tempNode.pos.y;
						cx++;
					}

				}

				if(cx>0){				
					x /= cx;
					y /= cx;

					middleNodes[i].pos.x += (x-middleNodes[i].pos.x)/stickFlow;
					middleNodes[i].pos.y += (y-middleNodes[i].pos.y)/stickFlow;
				}
			}
		}

		//and now, of course, the top point.
		x = 0;
		y = 0;
		cx=0;
		for(int i=0;i<MAX_BOTTOM_NODES;i++){
			if(middleNodes[i].childCount>0 && middleNodes[i].enabled){
				x += middleNodes[i].pos.x;
				y += middleNodes[i].pos.y;
				cx++;
			}
		}
		if(cx>0){
			x /= cx;
			y /= cx;

			topPoint.x+=(x-topPoint.x)/stickFlow;
			topPoint.y+=(y-topPoint.y)/stickFlow;
		}
	}


	public void calculateNodes(){
		boolean foundOne;
		for(int i=0;i<MAX_BOTTOM_NODES;i++){
			bottomNodes[i] = new Node((float)(Math.random()*19)*100.0f,
				(float)((Math.random()*26)*100.0f),-200.0f);
			for(int ii=0;ii<ucla.buildingCount;ii++){
				if(ucla.buildings[ii].midPoint.distanceFrom(bottomNodes[i].pos)<300){
					//check if it's already occupied
					foundOne=false;
					for(int iii=0;iii<i;iii++){
						for(int iiii=0;iiii<bottomNodes[iii].childCount;iiii++){
							if(bottomNodes[iii].children[iiii]==ii){
								foundOne=true;
								break;
							}
						}
						if(foundOne)break;
					}
					if(!foundOne)bottomNodes[i].addChild(ii);
				}
			}
		}
		//now make the middle nodes

		for(int i=0;i<MAX_BOTTOM_NODES;i++){
			middleNodes[i]= new Node((float)Math.random()*1900.0f/2.0f+600.0f,
				(float)Math.random()*2600.0f/2.0f+600.0f,-400.0f);
			//now add bottom nodes to it
			for(int ii=0;ii<MAX_BOTTOM_NODES;ii++){
				if(bottomNodes[ii].childCount>0){
					if(middleNodes[i].pos.distanceFrom(bottomNodes[ii].pos)<500){
						//first check to see if it's already taken
						foundOne = false;
						for(int iii=0;iii<i;iii++){
							for(int iiii=0;iiii<middleNodes[iii].childCount;iiii++){
								if(middleNodes[iii].children[iiii]==ii){
									foundOne=true;
									break;
								}
							}	
							if(foundOne)break;
						}
						if(!foundOne)middleNodes[i].addChild(ii);

					}
				}
			}
		}

	}

	public void borderMouseLeave(){
		networkColor.setDest(darkR,darkG,darkB,7.0f);
		if(state==STATE_COOLING)drawColor.setDest(darkR,darkG,darkB,5.0f);
		if(state==STATE_DRAWING)drawColor.setDest(255,0,0,5.0f);
	}

	public void borderMouseEnter(){
		networkColor.setDest(lightR,lightG,lightB,5.0f);
		drawColor.setDest(lightR,lightG,lightB,5.0f);
	}


}
