//
// WRITTEN BY JOSH NIMOY, AUG 2001, for Victoria Vesna, SINAPSE
// 
// If you use this code, I'm interested in knowing what you use it for.
// Please drop me a line - jtnimoy@ucla.edu or nimoy@media.mit.edu
//
//

public class Matrix{

	public Vector3D translate;
	public Vector3D scale;
	public Vector3D rotate;

	public Matrix(){
		this.translate = new Vector3D(0,0,0);
		this.scale = new Vector3D(1,1,1);
		this.rotate= new Vector3D(0,0,0);
	}


	public Matrix(Matrix m){
		this.translate = new Vector3D(m.translate);
		this.scale = new Vector3D(m.scale);
		this.rotate= new Vector3D(m.rotate);
	}


	public Vector3D apply(Vector3D p){
		
		p = rotate3D(p.x,p.y,p.z);

		p.x*=scale.x;
		p.y*=scale.y;
		p.z*=scale.z;
		
		p.x+=translate.x;
		p.y+=translate.y;
		p.z+=translate.z;
		
		return p;
	}

	public void translate(float x,float y,float z){
		Vector3D p = rotate3D(x,y,z);
		translate.x+=(p.x*scale.x);
		translate.y+=(p.y*scale.y);
		translate.z+=(z*scale.z);
	}

	public void scale(float x,float y,float z){
		scale.x *= x;
		scale.y *= y;
		scale.z *= z;
	}

	public void rotateX(float angle){
		rotate.x+=angle;
	}

	public void rotateY(float angle){
		rotate.y+=angle;
	}

	public void rotateZ(float angle){
		rotate.z+=angle;
	}

	//public Vector3D rotate2D(float x,float y,float angle){
	//	return new Vector3D(
	//		Math.cos(theta)*x - Math.sin(theta)*y ,
	//		Math.sin(theta)*x + Math.cos(theta)*y,
	//		0.0);
	//}

	public Vector3D rotate3D(float x,float y, float z){

		/*
		set thisPoint = getAt (points,i)      -- get this point reference
		set z = the zpos of thisPoint
		set x = the xpos of thisPoint
		set y = the ypos of thisPoint    
											  -- Y Rotate

		set temp_zpos             = z * cos(Yangle) - x * sin(Yangle)
		set the xpos of thisPoint = z * sin(Yangle) + x * cos(Yangle)    
											  -- X rotate
		set the zpos of thisPoint = y * sin(Xangle) + temp_zpos * cos(Xangle)
		set the ypos of thisPoint = y * cos(Xangle) - temp_zpos * sin(Xangle)
		
		x'=x*xvx+y*xvy+z*xvz+xv0
		y'=x*yvx+y*yvy+z*yvz+yv0
		z'=x*zvx+y*zvy+z*zvz+zv0 

		Xv = x(s1s2s3 + c1c3) + y(c2s3) + z(c1s2s3 - c3s1)
		Yv = x(c3s1s2 - c1s3) + y(c2c3) + z(c1c3s2 + s1s3)
		Zv = x(c1s2s3 - c3s1) + y(-s2)  + z(c1c2)

		Xv = x(sY*sZ*sX + cY*cX) + y(cZ*sX) + z(cY*sZ*sX - cX*sY)
		Yv = x(cX*sY*sZ - cY*sX) + y(cZ*cX) + z(cY*cX*sZ + sY*sX)
		Zv = x(cY*sZ*sX - cX*sY) + y(-sZ)  + z(cY*cZ)
		*/

		
		float tX = (rotate.z*(float)Math.PI)/180.0f;
		float tY = (rotate.y*(float)Math.PI)/180.0f;
		float tZ = (rotate.x*(float)Math.PI)/180.0f;

		float cX = (float)Math.cos(tX);
		float sX = (float)Math.sin(tX);
		float cY = (float)Math.cos(tY);
		float sY = (float)Math.sin(tY);
		float cZ = (float)Math.cos(tZ);
		float sZ = (float)Math.sin(tZ);

		float Xv = x*(sY*sZ*sX + cY*cX) + y*(cZ*sX) + z*(cY*sZ*sX - cX*sY);
		float Yv = x*(cX*sY*sZ - cY*sX) + y*(cZ*cX) + z*(cY*cX*sZ + sY*sX);
		float Zv = x*(cY*sZ*sX - cX*sY) + y*(-sZ  ) + z*(cY*cZ           );


		return new Vector3D(Xv,Yv,Zv);

	}

}

/*
//Rotation about the y axis: 
		float theta = (rotate.y*(float)Math.PI)/(float)180.0;
		float ct = (float)Math.cos(theta);
		float st = (float)Math.sin(theta);
		
		float x2 = (ct * x) + (st * z);
		float y2 = y;
		float z2 = (ct * z)-(st * x);
		
		//Rotatation about the x axis: 
		theta = (rotate.x*(float)Math.PI)/(float)180.0;
		ct = (float)Math.cos(theta);
		st = (float)Math.sin(theta);
		
		float x3 = x2;
		float y3 = (ct * y2) - (st * z2);
		float z3 = (st * y2) + (ct * z2);

		//Rotation about the z axis: 
		theta = (rotate.z*(float)Math.PI)/(float)180.0;
		ct = (float)Math.cos(theta);
		st = (float)Math.sin(theta);
		
		float x4 = (ct * x3) - (st * y3);
		float y4 = (st * x3) + (ct * y3);
		float z4 = z3;
*/