//
// WRITTEN BY JOSH NIMOY, AUG 2001, for Victoria Vesna, SINAPSE
// 
// If you use this code, I'm interested in knowing what you use it for.
// Please drop me a line - jtnimoy@ucla.edu or nimoy@media.mit.edu
//
//

import java.applet.*;
import java.awt.*;
import java.util.*;

public class NimoyGL{

	public Matrix matrix;
	public Stack matrixStack;
	public Image image;
	public Graphics graphics;

	public int width;
	public int height;

	public void translate(float x,float y,float z){matrix.translate(x,y,z);}
	public void scale(float x,float y,float z){matrix.scale(x,y,z);}
	public void scale(Vector3D v){matrix.scale(v.x,v.y,v.z);}
	public void rotateX(float angle){matrix.rotateX(angle);}
	public void rotateY(float angle){matrix.rotateY(angle);}
	public void rotateZ(float angle){matrix.rotateZ(angle);}
	public void setColor(Color c){
		graphics.setColor(c);
		if(savingAsIllustrator){
			String g = getCMYK(c);
            System.out.print(g);
			System.out.print(" K ");
			System.out.print(g);
			System.out.print(" k ");
		}
	}
	public void clear(){graphics.clearRect(0,0,width,height);}

	public boolean savingAsIllustrator=false;

	public void pushMatrix(){
		if(savingAsIllustrator)System.out.print(" u ");
		matrixStack.push(matrix);
		matrix = new Matrix(matrix);

	}
	public void popMatrix(){
		if(savingAsIllustrator)System.out.print(" U ");
		matrix = (Matrix)matrixStack.pop();
	}


	public void fillPolygon(Vector3D vlist[],int pnum){
		Vector3D p;
		int x[] = new int[pnum];
		int y[] = new int[pnum];
		for(int i=0;i<pnum;i++){
			p = project(matrix.apply(vlist[i]));
			x[i] = Math.round(p.x);
			y[i] = Math.round(p.y);
		}	
		graphics.fillPolygon(x,y,pnum);

		if(savingAsIllustrator){
			System.out.print(x[0]);
			System.out.print(" ");
			System.out.print(-y[0]);
			System.out.print(" m ");
			for(int i=0;i<pnum-1;i++){
				System.out.print(x[i]);
				System.out.print(" ");
				System.out.print(-y[i]);
				System.out.print(" l ");
				System.out.print(x[i+1]);
				System.out.print(" ");
				System.out.print(-y[i+1]);
				System.out.print(" l ");
			}
			System.out.print(x[0]);
			System.out.print(" ");
			System.out.print(-y[0]);
			System.out.print(" l B ");
		}
	}

	public void drawPolygon(Vector3D vlist[],int pnum){
		Vector3D p;
		int x[] = new int[pnum];
		int y[] = new int[pnum];
		for(int i=0;i<pnum;i++){
			p = project(matrix.apply(vlist[i]));
			x[i] = Math.round(p.x);
			y[i] = Math.round(p.y);
		}	
		graphics.drawPolygon(x,y,pnum);
		if(savingAsIllustrator){
			System.out.print(" u ");

			for(int i=0;i<pnum-1;i++){
				System.out.print(x[i]);
				System.out.print(" ");
				System.out.print(-y[i]);
				System.out.print(" m ");
				System.out.print(x[i+1]);
				System.out.print(" ");
				System.out.print(-y[i+1]);
				System.out.print(" l B ");
			}
			
			System.out.print(x[0]);
			System.out.print(" ");
			System.out.print(-y[0]);
			System.out.print(" m ");
			System.out.print(x[pnum-1]);
			System.out.print(" ");
			System.out.print(-y[pnum-1]);
			System.out.print(" l B ");
			System.out.print(" U ");
		}

	}

	public NimoyGL(int width,int height, Applet a){
		image = a.createImage(width,height);
		this.height = height;
		this.width = width;
		graphics = image.getGraphics();

		matrix = new Matrix();
		matrixStack = new Stack();
		//int g = 20;
	}

	public void drawLine(float x1,float y1,float z1, float x2,float y2, float z2){
		drawLine(new Vector3D(x1,y1,z1),new Vector3D(x2,y2,z2));
	}


	public void drawRect(float x1,float y1, float x2,float y2){
		Vector3D p1 = new Vector3D(x1,y1,0.0f);
		Vector3D p2 = new Vector3D(x1,y2,0.0f);
		Vector3D p3 = new Vector3D(x2,y2,0.0f);
		Vector3D p4 = new Vector3D(x2,y1,0.0f);
		if(savingAsIllustrator)System.out.print(" u ");
		drawLine(p1,p2);
		drawLine(p2,p3);
		drawLine(p3,p4);
		drawLine(p4,p1);
		if(savingAsIllustrator)System.out.print(" U ");
	}

	
	public void fillRect(int x1,int y1,int x2,int y2){
		Vector3D v[] = new Vector3D[4];
		/*
		int x[] = new int[4];
		int y[] = new int[4];
		x[0] = x1;y[0] = y1;
		x[1] = x2;y[1] = y1;
		x[2] = x2;y[2] = y2;
		x[3] = x1;y[3] = y2;
		*/
		v[0] = new Vector3D(x1,y1,0);
		v[1] = new Vector3D(x2,y1,0);
		v[2] = new Vector3D(x2,y2,0);
		v[3] = new Vector3D(x1,y2,0);

		//graphics.fillPolygon(x,y,4);
		fillPolygon(v,4);
	}

	public void drawLine(Vector3D v1, Vector3D v2){
		Vector3D p1 = project(matrix.apply(v1));
		Vector3D p2 = project(matrix.apply(v2));
		graphics.drawLine(
			Math.round(p1.x),
			Math.round(p1.y),
			Math.round(p2.x),
			Math.round(p2.y)
			);
		if(savingAsIllustrator){
			System.out.print(p1.x);
			System.out.print(" ");
			System.out.print(-p1.y);
			System.out.print(" m ");
			System.out.print(p2.x);
			System.out.print(" ");
			System.out.print(-p2.y);
			System.out.print(" l B ");
		}
	}

	public Vector3D project(Vector3D v){
		//move x and y toward the center according to z
		//		spx[0] = (int)(midwidth * a.x / a.z) + midwidth;
		if(v.z==0){
			return new Vector3D(v.x,v.y,0);
		}else{
			float d = 900.0f;
			float x = v.x - width/2;
			float y = v.y - height/2;
			float scalar = (1.0f / ((-v.z*1.0f)/d + 1.0f));
			x = x * scalar + width/2;
			y = y * scalar + height/2;


			//float x = v.x+(width/2-v.x)/v.z;
			//float y = v.y+(height/2-v.y)/v.z;
			return new Vector3D(x,y,0);
		}
	}

	public void drawBezier(
		float P0X,float P0Y,float P0Z,
		float P1X,float P1Y,float P1Z,
		float P2X,float P2Y,float P2Z,
		float P3X,float P3Y,float P3Z,int segs,int stopAt) {
		if(savingAsIllustrator){
			System.out.print(" u ");
			segs*=5;
			stopAt*=5;
		}
		float t=0.0f,dt=1.0f/(float)segs;		// calculating increment
		float Q0X,Q0Y,Q0Z;
		float Q1X,Q1Y,Q1Z;
		float Q2X,Q2Y,Q2Z;
		float R0X,R0Y,R0Z;
		float R1X,R1Y,R1Z;
		float x;float y;float z;
		float xx=P0X;float yy=P0Y;float zz=P0Z;
		for (int i=1;i<stopAt;i++) {
			Q0X = P0X + t*(P1X-P0X); Q0Y = P0Y + t*(P1Y-P0Y); Q0Z = P0Z + t*(P1Z-P0Z);
			Q1X = P1X + t*(P2X-P1X); Q1Y = P1Y + t*(P2Y-P1Y); Q1Z = P1Z + t*(P2Z-P1Z);
			Q2X = P2X + t*(P3X-P2X); Q2Y = P2Y + t*(P3Y-P2Y); Q2Z = P2Z + t*(P3Z-P2Z);
			R0X = Q0X + t*(Q1X-Q0X); R0Y = Q0Y + t*(Q1Y-Q0Y); R0Z = Q0Z + t*(Q1Z-Q0Z);
			R1X = Q1X + t*(Q2X-Q1X); R1Y = Q1Y + t*(Q2Y-Q1Y); R1Z = Q1Z + t*(Q2Z-Q1Z);
			x = R0X + t*(R1X-R0X);
			y = R0Y + t*(R1Y-R0Y);
			z = R0Z + t*(R1Z-R0Z);
			drawLine(xx,yy,zz,x,y,z);
			xx=x;
			yy=y;
			zz=z;
			t+=dt;
		}

			if(stopAt==segs)drawLine(xx,yy,zz,P3X,P3Y,P3Z);
			if(savingAsIllustrator)System.out.print(" U ");
	}

	public void enableIllustrator(){
        System.out.println("%!PS-Adobe-1.0");
        System.out.println("%%Creator: Adobe Illustrator");
        System.out.println("%%BoundingBox: 0 0 0 0");
        System.out.println("%%EndProlog");
        System.out.println("0 A 0 R 0 J 0 j 0.01 w");
		savingAsIllustrator=true;  
	}

	public void disableIllustrator(){
		savingAsIllustrator=false;
		System.out.println("");
		System.out.println("%%PageTrailer");
		System.out.println("%%EOF");
		System.out.println("");
	}


	public String getCMYK(Color rgbcolor){

		float c = (float)Math.abs(Math.ceil(rgbcolor.getRed()/256.0f*100.0f)-100);
		float m = (float)Math.abs(Math.ceil(rgbcolor.getGreen()/256.0f*100.0f)-100);
		float y = (float)Math.abs(Math.ceil(rgbcolor.getBlue()/256.0f*100.0f)-100);
		
		return (c/100.0f)+" "+(m/100.0f)+" "+(y/100.0f)+" 0";
	}

}
