//
// WRITTEN BY JOSH NIMOY, AUG 2001, for Victoria Vesna, SINAPSE
// 
// If you use this code, I'm interested in knowing what you use it for.
// Please drop me a line - jtnimoy@ucla.edu or nimoy@media.mit.edu
//
//


public class Polygon3D {
	public int size;
	public Vector3D vectors[];

	public Vector3D typeTranslation;
	public Vector3D curTranslation;
	public Vector3D destTranslation;
	public float destSpeed=5.0f;

	public Vector3D midPoint;

	public void frame(){
		if(curTranslation.x!=destTranslation.x)curTranslation.x+=(destTranslation.x-curTranslation.x)/destSpeed;
		if(curTranslation.y!=destTranslation.y)curTranslation.y+=(destTranslation.y-curTranslation.y)/destSpeed;
		if(curTranslation.z!=destTranslation.z)curTranslation.z+=(destTranslation.z-curTranslation.z)/destSpeed;
	}


	public Polygon3D(Vector3D v[],int vcount){
		size=vcount;
		vectors = v;
		typeTranslation = new Vector3D(0,0,0);
		curTranslation = new Vector3D(0,0,0);
		destTranslation = new Vector3D(0,0,0);
	}

	public void calculateMidPoint(){
		float x=0;
		float y=0;
		float z=0;
		for(int i=0;i<size;i++){
			x+=vectors[i].x;
			y+=vectors[i].y;
			z+=vectors[i].z;
		}
		midPoint = new Vector3D(x/size,y/size,z/size);
	}

	public Vector3D getMidpointWithCurTranslation(){
		return new Vector3D(curTranslation.x+midPoint.x,
			curTranslation.y+midPoint.y,
			curTranslation.z+midPoint.z);
	}


}

