//
// WRITTEN BY JOSH NIMOY, AUG 2001, for Victoria Vesna, SINAPSE
// 
// If you use this code, I'm interested in knowing what you use it for.
// Please drop me a line - jtnimoy@ucla.edu or nimoy@media.mit.edu
//
//

import java.awt.*;

public class Sprite{

	public boolean checked = false;

	public DestColor fill;
	public int x;
	public int y;
	public int w;
	public int h;
	public sinapseSplash ss;

	public int upR;
	public int upG;
	public int upB;
	public int downR;
	public int downG;
	public int downB;
	public int overR;
	public int overG;
	public int overB;
	public String statusMessage;

	public boolean mouseInside=false;
	public boolean mouseIsDown=false;

	public Sprite(int upR,int upG,int upB,
		int overR,int overG,int overB,
		int downR,int downG,int downB,
		int x,int y,int w,int h,boolean checked,sinapseSplash s,String statmsg){
		this.ss = s;
		this.x = x;
		this.y = y;
		this.w = w;
		this.h = h;

		this.upR = upR;
		this.upG = upG;
		this.upB = upB;
		
		this.downR = downR;
		this.downG = downG;
		this.downB = downB;
		
		this.overR = overR;
		this.overG = overG;
		this.overB = overB;
		this.checked = checked;
		fill = new DestColor(255,255,255,upR,upG,upB,50.0f);
		statusMessage=statmsg;
	}

	public void borderMouseEnter(){
		fill.setDest(255,255,255,3.0f);
	}

	public void borderMouseLeave(){
		fill.setDest(upR,upG,upB,50.0f);
	}

	public void frame(){
		if(ss.time>80){
			fill.frame();
			if(ss.mouseInBorder)fill.setDest(255,255,255,3.0f);
		}
	}

	public void draw(){
		ss.ngl.setColor(fill.getColor());
		ss.ngl.fillRect(x,y,x+w,y+h);
		if(!checked){
			ss.ngl.setColor(Color.white);
			ss.ngl.fillRect(x+1,y+1,x+w-1,y+h-1);
		}
	}

	public void mouseDown(int x,int y){
		checked = !checked;
		fill.setDest(downR,downG,downB,3.0f);
	}

	public void mouseUp(int x,int y){
		fill.setDest(overR,overG,overB,3.0f);
	}

	public void mouseUpOutside(int x,int y){
		if(!ss.mouseInBorder)fill.setDest(upR,upG,upB,2.0f);
	}

	public void mouseEnter(int x,int y){
		if(mouseIsDown)fill.setDest(downR,downG,downB,2.0f);
		else fill.setDest(overR,overG,overB,2.0f);

		ss.statusMessage = this.statusMessage;
	}

	
	public void mouseLeave(int x,int y){
		fill.setDest(upR,upG,upB,10.0f);
		ss.statusMessage = "";
	}

	public boolean pickCheck(int x,int y){
		if((x>this.x&&x<this.w+this.x)&&(y>this.y&&y<this.h+this.y))return true;
		else return false;
	}

}

