//
// WRITTEN BY JOSH NIMOY, AUG 2001, for Victoria Vesna, SINAPSE
// 
// If you use this code, I'm interested in knowing what you use it for.
// Please drop me a line - jtnimoy@ucla.edu or nimoy@media.mit.edu
//
//


import java.util.*;

public class UCLA 
{
	public int buildingCount = 160;
	public int areaCount = 45;

	public Polygon3D buildings[];


	public void frame(){
			for(int i=0;i<buildingCount;i++)
					buildings[i].frame();
	}

	public UCLA(){
		StringTokenizer st = new StringTokenizer(buildValString," ");
		buildings = new Polygon3D[buildingCount];
		int c;
		float x;
		float y;
		//load the building shapes
		for(int i=0;i<buildingCount;i++){
			c = Integer.valueOf(st.nextToken()).intValue();
			buildings[i] = new Polygon3D(new Vector3D[c],c);
			buildings[i].typeTranslation.x=Float.valueOf(st.nextToken()).floatValue();
			buildings[i].typeTranslation.y=Float.valueOf(st.nextToken()).floatValue();
			for(int ii=0;ii<c;ii++){
				x = Float.valueOf(st.nextToken()).floatValue();
				y = Float.valueOf(st.nextToken()).floatValue();
				buildings[i].vectors[ii] = new Vector3D(x,y,0);
			}
			buildings[i].calculateMidPoint();
		}
	}
	public String buildValString = "4 201.76509 877.94104 69.0 353.0 101.0 371.0 103.0 356.0 75.0 343.0 \
4 -41.176064 674.2357 114.0 359.0 125.0 340.0 112.0 329.0 100.0 350.0 4 \
211.765 765.8236 67.0 337.0 89.0 344.0 94.0 323.0 78.0 317.0 4 783.1767 \
648.7059 201.0 590.0 219.0 581.0 196.0 518.0 175.0 530.0 6 -107.000275 \
594.1175 213.0 626.0 229.0 617.0 240.0 626.0 250.0 611.0 265.0 627.0 227.0 \
647.0 7 255.17654 472.8235 166.0 658.0 147.0 649.0 208.0 614.0 194.0 590.0 \
132.0 639.0 136.0 669.0 162.0 674.0 4 -246.2352 767.2352 168.0 641.0 171.0 \
656.0 207.0 640.0 197.0 625.0 18 1126.0583 588.23517 371.0 510.0 379.0 479.0 \
420.0 491.0 423.0 481.0 402.0 467.0 412.0 454.0 435.0 463.0 440.0 452.0 \
463.0 463.0 458.0 485.0 438.0 479.0 420.0 515.0 429.0 531.0 423.0 542.0 \
402.0 524.0 409.0 503.0 392.0 499.0 385.0 514.0 4 1352.9409 859.35266 429.0 \
536.0 438.0 536.0 445.0 554.0 431.0 551.0 4 435.29404 531.6474 434.0 520.0 \
462.0 570.0 487.0 553.0 458.0 503.0 16 171.99976 444.29443 333.0 601.0 343.0 \
601.0 343.0 586.0 395.0 587.0 395.0 598.0 406.0 598.0 408.0 617.0 383.0 \
619.0 381.0 656.0 396.0 655.0 397.0 694.0 341.0 695.0 343.0 658.0 360.0 \
657.0 360.0 618.0 330.0 618.0 5 -70.58901 452.9415 434.0 635.0 513.0 785.0 \
528.0 746.0 518.0 743.0 450.0 625.0 6 59.941113 244.58835 517.0 726.0 529.0 \
669.0 472.0 654.0 476.0 632.0 550.0 655.0 532.0 732.0 10 1055.8229 519.29456 \
489.0 622.0 560.0 646.0 576.0 578.0 566.0 553.0 549.0 562.0 555.0 578.0 \
546.0 619.0 508.0 604.0 502.0 587.0 481.0 592.0 8 1258.8226 706.17633 521.0 \
599.0 535.0 600.0 542.0 578.0 532.0 569.0 532.0 554.0 519.0 542.0 509.0 \
575.0 521.0 581.0 4 -263.58832 422.412 413.0 781.0 388.0 775.0 376.0 742.0 \
415.0 742.0 10 -705.88354 352.94116 583.0 573.0 618.0 648.0 678.0 623.0 \
652.0 612.0 626.0 624.0 608.0 585.0 635.0 570.0 652.0 612.0 680.0 623.0 \
643.0 543.0 8 -784.5883 147.05869 571.0 698.0 576.0 653.0 656.0 663.0 663.0 \
654.0 671.0 666.0 664.0 674.0 661.0 698.0 639.0 707.0 17 940.05853 202.52997 \
572.0 719.0 614.0 719.0 615.0 710.0 636.0 710.0 635.0 844.0 577.0 842.0 \
557.0 853.0 557.0 803.0 568.0 801.0 568.0 790.0 584.0 790.0 587.0 773.0 \
593.0 772.0 593.0 760.0 562.0 760.0 562.0 739.0 573.0 739.0 4 1345.1171 \
248.41214 557.0 884.0 578.0 878.0 578.0 856.0 555.0 856.0 16 1287.1168 \
524.9416 424.0 878.0 481.0 879.0 486.0 836.0 461.0 833.0 462.0 795.0 470.0 \
795.0 471.0 764.0 461.0 763.0 461.0 749.0 439.0 749.0 439.0 763.0 428.0 \
764.0 429.0 796.0 439.0 796.0 439.0 832.0 417.0 832.0 4 1529.411 424.1179 \
282.0 854.0 265.0 855.0 263.0 810.0 284.0 810.0 4 1665.8226 211.76495 287.0 \
833.0 321.0 831.0 329.0 867.0 298.0 867.0 4 752.9413 518.76544 240.0 863.0 \
284.0 865.0 283.0 909.0 241.0 902.0 4 635.2933 311.76566 286.0 923.0 321.0 \
923.0 321.0 905.0 289.0 905.0 4 170.5888 447.05948 304.0 896.0 344.0 894.0 \
344.0 876.0 305.0 875.0 8 1770.4116 416.35315 175.0 992.0 223.0 988.0 220.0 \
895.0 208.0 895.0 208.0 874.0 156.0 876.0 161.0 919.0 171.0 919.0 4 \
1334.1761 363.58853 575.0 1042.0 574.0 973.0 623.0 973.0 623.0 1042.0 4 \
1525.764 -248.17595 551.0 1067.0 551.0 1051.0 665.0 1052.0 665.0 1067.0 \
8 -1048.7068 167.41188 704.0 914.0 737.0 903.0 728.0 846.0 729.0 771.0 738.0 \
719.0 704.0 710.0 691.0 780.0 694.0 856.0 25 -676.4703 81.52957 738.0 927.0 \
753.0 933.0 756.0 903.0 775.0 921.0 808.0 920.0 834.0 896.0 843.0 870.0 \
840.0 755.0 828.0 723.0 807.0 710.0 770.0 712.0 757.0 722.0 757.0 748.0 \
775.0 725.0 801.0 725.0 822.0 743.0 825.0 755.0 826.0 872.0 822.0 891.0 \
806.0 903.0 784.0 906.0 760.0 888.0 756.0 870.0 755.0 687.0 738.0 695.0 10 \
742.8231 321.64752 714.0 986.0 715.0 1016.0 735.0 1016.0 754.0 1060.0 805.0 \
1065.0 805.0 1037.0 821.0 1037.0 822.0 975.0 748.0 973.0 735.0 987.0 \
8 -817.64746 30.235992 644.0 1152.0 706.0 1157.0 706.0 1139.0 720.0 1137.0 \
720.0 1091.0 686.0 1092.0 687.0 1138.0 648.0 1137.0 8 1119.3525 -170.70526 \
832.0 995.0 834.0 968.0 870.0 968.0 871.0 984.0 879.0 984.0 879.0 1067.0 \
852.0 1067.0 852.0 995.0 4 230.41193 153.47112 887.0 970.0 887.0 1072.0 \
1022.0 1072.0 1022.0 970.0 4 -598.88293 -142.29332 871.0 1210.0 872.0 1083.0 \
1014.0 1083.0 1015.0 1210.0 4 -951.5877 300.82382 1019.0 1195.0 1103.0 \
1195.0 1103.0 1105.0 1019.0 1105.0 4 1128.2941 -151.41122 807.0 1326.0 806.0 \
1242.0 1045.0 1242.0 1047.0 1332.0 4 -955.2355 -218.35223 1081.0 1328.0 \
1084.0 1242.0 1117.0 1243.0 1116.0 1329.0 6 -1205.8832 34.176968 877.0 \
1405.0 1091.0 1436.0 1105.0 1375.0 1086.0 1369.0 1084.0 1382.0 881.0 1353.0 \
4 7.2938156 -332.76465 880.0 1461.0 928.0 1469.0 938.0 1443.0 883.0 1434.0 \
4 -737.2944 -252.94025 1034.0 1478.0 1090.0 1491.0 1089.0 1461.0 1039.0 \
1453.0 4 677.58777 -684.5876 896.0 1552.0 1066.0 1578.0 1078.0 1496.0 904.0 \
1475.0 4 15.117645 -470.58795 1154.0 1429.0 1182.0 1427.0 1190.0 1364.0 \
1161.0 1361.0 4 -102.23565 -403.35208 1217.0 1430.0 1251.0 1430.0 1251.0 \
1354.0 1217.0 1354.0 4 -863.4715 -196.64627 1151.0 1506.0 1226.0 1501.0 \
1226.0 1456.0 1151.0 1456.0 4 -168.35281 -183.35242 1142.0 1522.0 1143.0 \
1556.0 1178.0 1553.0 1180.0 1522.0 4 127.176346 -532.76373 1207.0 1526.0 \
1255.0 1526.0 1259.0 1574.0 1208.0 1574.0 6 -30.528938 -735.23444 1152.0 \
1592.0 1152.0 1676.0 1206.0 1676.0 1206.0 1631.0 1190.0 1630.0 1189.0 1592.0 \
6 -1173.9409 -440.82248 1235.0 1601.0 1235.0 1719.0 1277.0 1720.0 1281.0 \
1641.0 1256.0 1640.0 1255.0 1601.0 9 262.47147 23.530087 1091.0 1067.0 \
1115.0 1067.0 1115.0 1054.0 1136.0 1051.0 1135.0 1021.0 1102.0 1016.0 1102.0 \
1025.0 1072.0 1024.0 1071.0 1058.0 4 -338.82367 507.2358 1038.0 986.0 1106.0 \
986.0 1107.0 950.0 1037.0 951.0 10 -141.94122 -424.64627 854.0 1755.0 866.0 \
1763.0 932.0 1762.0 944.0 1756.0 942.0 1585.0 932.0 1579.0 877.0 1580.0 \
876.0 1651.0 860.0 1660.0 854.0 1672.0 13 954.05896 -423.70526 946.0 1751.0 \
947.0 1639.0 954.0 1639.0 956.0 1597.0 1001.0 1596.0 1001.0 1612.0 995.0 \
1618.0 986.0 1618.0 985.0 1678.0 996.0 1678.0 986.0 1738.0 978.0 1737.0 \
978.0 1753.0 6 1111.7645 -197.47012 1016.0 1617.0 1016.0 1593.0 1079.0 \
1593.0 1081.0 1678.0 1054.0 1675.0 1053.0 1620.0 4 15.88179 -371.94104 \
1192.0 1257.0 1292.0 1259.0 1288.0 1174.0 1189.0 1175.0 \
8 -77.88164 -56.587914 1192.0 1164.0 1223.0 1167.0 1226.0 1158.0 1296.0 \
1156.0 1296.0 1132.0 1228.0 1129.0 1230.0 1090.0 1198.0 1086.0 9 \
551.52875 -63.58822 1204.0 1055.0 1258.0 1055.0 1258.0 966.0 1243.0 966.0 \
1243.0 946.0 1195.0 946.0 1176.0 968.0 1174.0 1036.0 1203.0 1037.0 \
8 -718.4722 8.11772 1268.0 1034.0 1266.0 977.0 1324.0 978.0 1325.0 995.0 \
1302.0 995.0 1303.0 1020.0 1325.0 1023.0 1327.0 1040.0 \
4 -1433.4121 -665.8235 1304.0 1575.0 1330.0 1574.0 1330.0 1526.0 1305.0 \
1525.0 4 -1659.8229 -610.23444 1347.0 1574.0 1347.0 1534.0 1395.0 1535.0 \
1395.0 1576.0 4 -1552.9407 -535.29364 1281.0 1615.0 1281.0 1598.0 1332.0 \
1597.0 1331.0 1613.0 4 -1031.6477 -358.94067 1347.0 1613.0 1347.0 1600.0 \
1396.0 1599.0 1396.0 1613.0 4 -1514.4119 -816.88116 1293.0 1661.0 1292.0 \
1703.0 1378.0 1706.0 1377.0 1660.0 4 -1697.7653 -671.7043 1391.0 1645.0 \
1392.0 1705.0 1428.0 1706.0 1427.0 1646.0 4 -1637.5297 -543.70544 1433.0 \
1720.0 1465.0 1718.0 1464.0 1666.0 1431.0 1666.0 10 -1587.1174 -412.8809 \
1449.0 1589.0 1452.0 1564.0 1434.0 1561.0 1438.0 1532.0 1413.0 1531.0 1412.0 \
1540.0 1422.0 1540.0 1422.0 1576.0 1440.0 1576.0 1440.0 1589.0 \
8 -1539.7651 -650.4108 1261.0 1507.0 1261.0 1460.0 1300.0 1460.0 1302.0 \
1448.0 1377.0 1445.0 1377.0 1455.0 1323.0 1454.0 1324.0 1508.0 \
4 -105.88245 -394.47034 1288.0 1423.0 1312.0 1423.0 1313.0 1363.0 1290.0 \
1363.0 16 270.58765 34.177277 1327.0 1428.0 1421.0 1420.0 1426.0 1456.0 \
1441.0 1454.0 1441.0 1420.0 1490.0 1421.0 1490.0 1371.0 1468.0 1369.0 1468.0 \
1388.0 1480.0 1391.0 1480.0 1405.0 1383.0 1398.0 1384.0 1378.0 1363.0 1378.0 \
1363.0 1398.0 1331.0 1396.0 12 -434.17645 -4.529003 1387.0 1450.0 1388.0 \
1498.0 1414.0 1498.0 1414.0 1511.0 1438.0 1508.0 1438.0 1495.0 1480.0 1492.0 \
1480.0 1447.0 1449.0 1447.0 1449.0 1463.0 1420.0 1460.0 1420.0 1447.0 6 \
824.0588 -470.58804 1180.0 1343.0 1367.0 1345.0 1367.0 1301.0 1315.0 1298.0 \
1314.0 1279.0 1179.0 1279.0 4 -933.4121 -92.58799 1380.0 1153.0 1379.0 \
1124.0 1333.0 1126.0 1333.0 1151.0 8 -191.58887 178.88263 1308.0 1156.0 \
1306.0 1257.0 1332.0 1259.0 1334.0 1233.0 1376.0 1231.0 1376.0 1174.0 1332.0 \
1174.0 1332.0 1156.0 4 -1096.3534 -153.47043 1414.0 1286.0 1414.0 1267.0 \
1452.0 1265.0 1452.0 1287.0 14 -1025.6475 -149.94046 1463.0 1276.0 1474.0 \
1264.0 1491.0 1262.0 1499.0 1271.0 1499.0 1302.0 1490.0 1313.0 1493.0 1322.0 \
1505.0 1322.0 1505.0 1347.0 1472.0 1346.0 1463.0 1331.0 1473.0 1324.0 1471.0 \
1304.0 1463.0 1298.0 4 -753.9409 -309.764 1518.0 1421.0 1518.0 1372.0 1550.0 \
1371.0 1549.0 1421.0 4 -1023.529 -52.94067 1522.0 1478.0 1523.0 1457.0 \
1575.0 1457.0 1577.0 1478.0 5 -177.58783 -190.47017 1522.0 1359.0 1520.0 \
1322.0 1553.0 1322.0 1567.0 1331.0 1568.0 1364.0 7 -402.23566 24.647596 \
1574.0 1330.0 1553.0 1318.0 1552.0 1284.0 1562.0 1281.0 1562.0 1264.0 1604.0 \
1264.0 1608.0 1332.0 12 -1762.1775 -141.17607 1515.0 1314.0 1539.0 1314.0 \
1542.0 1257.0 1610.0 1254.0 1610.0 1231.0 1486.0 1229.0 1484.0 1194.0 1468.0 \
1195.0 1466.0 1256.0 1505.0 1255.0 1505.0 1266.0 1515.0 1266.0 \
8 -202.1763 -30.882553 1507.0 1224.0 1539.0 1222.0 1541.0 1152.0 1466.0 \
1151.0 1466.0 1190.0 1482.0 1190.0 1484.0 1173.0 1508.0 1173.0 \
12 -636.0586 -86.05878 1573.0 1225.0 1592.0 1225.0 1591.0 1176.0 1610.0 \
1174.0 1610.0 1150.0 1598.0 1149.0 1598.0 1134.0 1574.0 1134.0 1574.0 1151.0 \
1545.0 1151.0 1546.0 1174.0 1572.0 1175.0 6 -496.99942 185.47061 1465.0 \
1132.0 1485.0 1132.0 1485.0 1125.0 1500.0 1123.0 1502.0 1089.0 1465.0 1090.0 \
6 -964.70544 58.82341 1506.0 1092.0 1508.0 1122.0 1523.0 1130.0 1556.0 \
1130.0 1560.0 1114.0 1559.0 1092.0 6 -875.5884 325.53003 1565.0 1092.0 \
1566.0 1109.0 1572.0 1109.0 1572.0 1127.0 1607.0 1129.0 1608.0 1092.0 8 \
550.05914 -11.2354145 1359.0 1048.0 1404.0 1047.0 1404.0 969.0 1357.0 970.0 \
1355.0 994.0 1385.0 994.0 1384.0 1023.0 1358.0 1023.0 6 111.76417 470.5886 \
1491.0 991.0 1492.0 951.0 1536.0 951.0 1537.0 970.0 1523.0 970.0 1523.0 \
991.0 10 -1811.7632 296.11777 1448.0 1000.0 1448.0 1033.0 1455.0 1033.0 \
1455.0 1060.0 1481.0 1062.0 1484.0 1050.0 1497.0 1048.0 1499.0 1024.0 1471.0 \
1021.0 1471.0 1002.0 8 -1203.0596 429.8825 1505.0 1007.0 1504.0 1055.0 \
1563.0 1056.0 1564.0 947.0 1542.0 948.0 1542.0 1019.0 1529.0 1019.0 1529.0 \
1006.0 22 105.23456 -543.7057 1608.0 1447.0 1638.0 1465.0 1637.0 1479.0 \
1648.0 1483.0 1654.0 1474.0 1666.0 1480.0 1659.0 1497.0 1672.0 1505.0 1702.0 \
1449.0 1671.0 1433.0 1668.0 1447.0 1683.0 1456.0 1677.0 1473.0 1662.0 1462.0 \
1687.0 1414.0 1637.0 1384.0 1608.0 1447.0 1626.0 1440.0 1644.0 1408.0 1666.0 \
1417.0 1647.0 1450.0 1627.0 1441.0 8 -1775.3529 41.176468 1657.0 1343.0 \
1721.0 1340.0 1720.0 1246.0 1728.0 1245.0 1728.0 1234.0 1722.0 1234.0 1719.0 \
1148.0 1657.0 1148.0 15 -1212.8827 -54.235214 1725.0 1060.0 1740.0 1077.0 \
1773.0 1081.0 1773.0 1019.0 1751.0 1019.0 1751.0 1004.0 1771.0 1004.0 1773.0 \
968.0 1734.0 968.0 1733.0 1016.0 1727.0 1016.0 1727.0 1032.0 1734.0 1033.0 \
1734.0 1050.0 1726.0 1052.0 22 -770.5877 5.882389 1611.0 904.0 1611.0 961.0 \
1639.0 961.0 1641.0 978.0 1617.0 978.0 1618.0 998.0 1660.0 1000.0 1661.0 \
1019.0 1640.0 1019.0 1638.0 1009.0 1625.0 1010.0 1627.0 1045.0 1677.0 1044.0 \
1676.0 1011.0 1693.0 1009.0 1693.0 997.0 1679.0 997.0 1682.0 940.0 1693.0 \
939.0 1693.0 912.0 1653.0 913.0 1653.0 904.0 8 -542.295 -35.29415 1051.0 \
926.0 1151.0 922.0 1151.0 828.0 1052.0 829.0 1055.0 879.0 1085.0 880.0 \
1085.0 898.0 1054.0 897.0 6 -891.8831 587.1182 1164.0 902.0 1176.0 902.0 \
1178.0 836.0 1158.0 836.0 1158.0 885.0 1166.0 885.0 6 -705.8826 382.35312 \
1205.0 926.0 1274.0 926.0 1274.0 828.0 1255.0 828.0 1224.0 828.0 1204.0 \
839.0 15 -1128.766 593.7653 1206.0 808.0 1268.0 809.0 1264.0 797.0 1264.0 \
773.0 1281.0 784.0 1283.0 753.0 1265.0 767.0 1264.0 756.0 1210.0 757.0 \
1205.0 778.0 1195.0 769.0 1185.0 777.0 1187.0 795.0 1200.0 795.0 1205.0 \
794.0 4 -931.64777 140.05902 1200.0 746.0 1274.0 745.0 1273.0 662.0 1201.0 \
662.0 10 -1620.1769 190.47066 1319.0 725.0 1370.0 725.0 1373.0 663.0 1349.0 \
663.0 1349.0 651.0 1315.0 650.0 1315.0 667.0 1292.0 667.0 1293.0 703.0 \
1308.0 705.0 7 -374.23514 268.35278 1196.0 628.0 1205.0 633.0 1221.0 639.0 \
1236.0 627.0 1235.0 609.0 1223.0 599.0 1205.0 597.0 6 257.70605 288.23596 \
1239.0 623.0 1280.0 631.0 1287.0 599.0 1276.0 593.0 1276.0 581.0 1246.0 \
581.0 4 -682.7066 696.6473 1289.0 573.0 1289.0 539.0 1258.0 530.0 1259.0 \
565.0 8 605.76495 279.35324 1295.0 599.0 1306.0 597.0 1314.0 590.0 1314.0 \
582.0 1356.0 591.0 1353.0 606.0 1339.0 624.0 1295.0 620.0 6 -351.41165 \
855.6475 1314.0 572.0 1334.0 572.0 1333.0 537.0 1303.0 537.0 1296.0 555.0 \
1310.0 558.0 7 -183.11746 752.58875 1329.0 523.0 1304.0 522.0 1301.0 515.0 \
1292.0 515.0 1291.0 489.0 1339.0 489.0 1339.0 514.0 9 -787.1181 867.4125 \
1347.0 623.0 1394.0 624.0 1391.0 444.0 1352.0 444.0 1351.0 521.0 1339.0 \
521.0 1338.0 581.0 1362.0 587.0 1358.0 606.0 10 98.882355 337.52942 1418.0 \
512.0 1440.0 513.0 1442.0 524.0 1475.0 525.0 1479.0 489.0 1471.0 486.0 \
1468.0 480.0 1450.0 479.0 1450.0 490.0 1418.0 492.0 21 390.47058 1019.7074 \
1252.0 435.0 1260.0 435.0 1268.0 447.0 1268.0 423.0 1214.0 396.0 1217.0 \
366.0 1229.0 366.0 1229.0 382.0 1254.0 398.0 1275.0 387.0 1289.0 368.0 \
1322.0 385.0 1309.0 414.0 1277.0 393.0 1271.0 408.0 1265.0 412.0 1293.0 \
423.0 1295.0 473.0 1274.0 480.0 1270.0 458.0 1253.0 455.0 5 262.1764 \
610.3535 1220.0 354.0 1235.0 356.0 1247.0 288.0 1235.0 288.0 1229.0 294.0 \
7 -466.11807 852.94183 1250.0 270.0 1286.0 283.0 1306.0 204.0 1282.0 213.0 \
1274.0 244.0 1257.0 244.0 1247.0 252.0 6 483.47064 673.1178 1418.0 266.0 \
1455.0 263.0 1478.0 260.0 1478.0 248.0 1424.0 248.0 1417.0 256.0 4 472.8235 \
401.11783 1433.0 452.0 1460.0 452.0 1460.0 404.0 1433.0 404.0 10 641.05884 \
857.059 1411.0 538.0 1414.0 601.0 1440.0 612.0 1478.0 612.0 1485.0 598.0 \
1487.0 544.0 1465.0 545.0 1465.0 584.0 1427.0 581.0 1427.0 539.0 \
7 -340.35327 882.05884 1503.0 611.0 1503.0 586.0 1526.0 584.0 1526.0 538.0 \
1547.0 537.0 1550.0 584.0 1556.0 610.0 12 515.4114 747.05914 1394.0 746.0 \
1388.0 724.0 1385.0 695.0 1394.0 664.0 1478.0 665.0 1479.0 644.0 1494.0 \
644.0 1496.0 683.0 1472.0 683.0 1473.0 727.0 1491.0 734.0 1483.0 749.0 \
14 -1223.5298 703.6478 1516.0 747.0 1563.0 749.0 1562.0 643.0 1516.0 646.0 \
1516.0 668.0 1535.0 671.0 1535.0 683.0 1515.0 685.0 1508.0 691.0 1508.0 \
704.0 1517.0 710.0 1535.0 712.0 1535.0 730.0 1514.0 730.0 \
9 -283.4709 -20.999851 1399.0 826.0 1401.0 909.0 1420.0 911.0 1421.0 870.0 \
1431.0 870.0 1460.0 889.0 1461.0 907.0 1478.0 907.0 1480.0 823.0 \
4 -657.7051 -24.645988 1517.0 924.0 1563.0 922.0 1563.0 823.0 1514.0 822.0 \
4 -1329.4138 735.2939 1596.0 209.0 1596.0 145.0 1725.0 146.0 1723.0 209.0 \
6 -1359.9417 1087.9419 1632.0 301.0 1651.0 302.0 1651.0 272.0 1715.0 271.0 \
1716.0 229.0 1628.0 229.0 13 -750.70636 553.0002 1527.0 340.0 1527.0 362.0 \
1575.0 362.0 1575.0 304.0 1618.0 305.0 1620.0 281.0 1610.0 281.0 1610.0 \
248.0 1575.0 248.0 1557.0 301.0 1559.0 310.0 1541.0 310.0 1539.0 338.0 \
12 -303.3529 632.7653 1629.0 308.0 1628.0 357.0 1735.0 357.0 1736.0 331.0 \
1743.0 331.0 1743.0 308.0 1736.0 308.0 1734.0 282.0 1673.0 284.0 1674.0 \
330.0 1652.0 329.0 1650.0 308.0 4 -1452.9417 1152.6478 1722.0 266.0 1751.0 \
267.0 1751.0 237.0 1721.0 237.0 8 -1415.4117 876.1768 1476.0 405.0 1476.0 \
468.0 1533.0 467.0 1534.0 486.0 1558.0 486.0 1557.0 465.0 1572.0 466.0 \
1572.0 402.0 10 -738.6471 769.1769 1563.0 492.0 1563.0 512.0 1650.0 515.0 \
1651.0 560.0 1692.0 559.0 1692.0 498.0 1676.0 497.0 1675.0 486.0 1611.0 \
486.0 1611.0 492.0 12 -938.9412 481.23636 1742.0 439.0 1776.0 438.0 1777.0 \
529.0 1784.0 529.0 1784.0 576.0 1730.0 576.0 1731.0 530.0 1743.0 530.0 \
1743.0 524.0 1719.0 524.0 1720.0 486.0 1741.0 485.0 6 -259.94284 882.3539 \
1810.0 451.0 1836.0 525.0 1857.0 518.0 1835.0 457.0 1823.0 455.0 1820.0 \
446.0 4 -782.8243 775.2362 1731.0 608.0 1731.0 589.0 1768.0 590.0 1769.0 \
608.0 4 -76.47098 245.94128 1689.0 668.0 1605.0 666.0 1607.0 612.0 1685.0 \
612.0 13 -469.47104 194.41211 1745.0 660.0 1764.0 660.0 1765.0 647.0 1798.0 \
648.0 1799.0 692.0 1788.0 692.0 1789.0 731.0 1867.0 725.0 1870.0 647.0 \
1855.0 646.0 1855.0 627.0 1761.0 627.0 1747.0 639.0 10 283.17557 733.23645 \
1728.0 753.0 1744.0 750.0 1770.0 729.0 1771.0 708.0 1758.0 707.0 1757.0 \
671.0 1731.0 669.0 1732.0 723.0 1725.0 731.0 1728.0 741.0 15 -975.3526 \
461.882 1728.0 827.0 1727.0 848.0 1737.0 859.0 1738.0 910.0 1764.0 912.0 \
1767.0 876.0 1870.0 876.0 1872.0 846.0 1885.0 846.0 1885.0 827.0 1845.0 \
827.0 1833.0 850.0 1765.0 846.0 1764.0 833.0 1755.0 827.0 4 \
1476.587 -1075.7643 513.0 2071.0 532.0 2058.0 505.0 2014.0 484.0 2028.0 6 \
1491.8815 -763.705 481.0 2022.0 508.0 1999.0 489.0 1971.0 474.0 1983.0 487.0 \
2002.0 475.0 2011.0 11 1150.94 -784.3522 586.0 2062.0 601.0 2052.0 619.0 \
2062.0 622.0 2037.0 616.0 2022.0 655.0 1996.0 613.0 1932.0 580.0 1918.0 \
528.0 1955.0 581.0 2026.0 568.0 2037.0 4 -616.531 -579.05804 728.0 1852.0 \
728.0 1818.0 774.0 1816.0 775.0 1852.0 4 -153.94092 -525.5295 855.0 1916.0 \
855.0 1883.0 903.0 1883.0 902.0 1917.0 4 -831.6467 -678.70526 889.0 1836.0 \
970.0 1835.0 970.0 1803.0 890.0 1803.0 4 817.6465 -1076.47 855.0 2189.0 \
837.0 2162.0 853.0 2151.0 871.0 2180.0 4 594.1167 -1088.234 799.0 2221.0 \
776.0 2185.0 794.0 2171.0 823.0 2208.0 6 119.05878 -319.64713 988.0 1810.0 \
997.0 1750.0 1062.0 1749.0 1063.0 1782.0 1035.0 1783.0 1036.0 1813.0 \
4 -109.765114 -791.35297 1018.0 1981.0 1018.0 1944.0 1037.0 1944.0 1037.0 \
1980.0 4 -1426.0591 -563.5881 1125.0 1953.0 1125.0 1917.0 1159.0 1915.0 \
1158.0 1953.0 4 -1490.4718 -437.4116 1159.0 1785.0 1215.0 1783.0 1215.0 \
1731.0 1158.0 1731.0 4 -1347.0593 -834.4701 1413.0 1941.0 1434.0 1943.0 \
1437.0 1911.0 1418.0 1908.0 10 958.82245 -1090.8806 648.0 2192.0 679.0 \
2238.0 664.0 2247.0 679.0 2268.0 693.0 2262.0 700.0 2276.0 749.0 2241.0 \
721.0 2210.0 702.0 2219.0 673.0 2177.0 4 -335.2953 -981.23376 772.0 2235.0 \
785.0 2228.0 802.0 2254.0 790.0 2262.0 9 -1161.8827 -879.235 814.0 2266.0 \
814.0 2251.0 836.0 2233.0 850.0 2233.0 865.0 2250.0 855.0 2272.0 838.0 \
2284.0 829.0 2278.0 821.0 2279.0 4 -675.35297 -1256.5872 760.0 2321.0 798.0 \
2300.0 782.0 2276.0 750.0 2296.0 5 -853.76434 -957.7054 719.0 2375.0 702.0 \
2365.0 701.0 2345.0 735.0 2324.0 756.0 2349.0 6 -257.7064 -978.9995 812.0 \
2447.0 784.0 2473.0 754.0 2432.0 769.0 2420.0 787.0 2446.0 804.0 2432.0 \
4 -224.64694 -1404.1759 792.0 2486.0 817.0 2527.0 838.0 2518.0 811.0 2473.0 \
4 -415.11807 -890.76434 898.0 2262.0 908.0 2281.0 931.0 2265.0 919.0 2246.0 \
4 531.9407 -952.1156 1021.0 2432.0 966.0 2353.0 983.0 2341.0 1038.0 2421.0 \
4 -1175.3545 -1141.176 994.0 2636.0 983.0 2609.0 1054.0 2587.0 1061.0 2615.0 \
5 -869.47076 -1438.9402 1149.0 2603.0 1134.0 2570.0 1159.0 2556.0 1185.0 \
2563.0 1174.0 2590.0 4 -1355.1755 -1401.9396 1220.0 2223.0 1287.0 2293.0 \
1305.0 2280.0 1238.0 2210.0 4 -927.17664 -1253.2344 1264.0 2451.0 1231.0 \
2415.0 1244.0 2400.0 1280.0 2439.0 4 -1070.8826 -1323.5288 1342.0 2528.0 1332.0 2505.0 \
1378.0 2489.0 1386.0 2515.0";
	
	public Vector3D areaShape[]={new Vector3D(17,319,0),
					new Vector3D(178,169,0),
					new Vector3D(251,162,0),
					new Vector3D(575,340,0),
					new Vector3D(653,440,0),
					new Vector3D(705,557,0),
					new Vector3D(750,594,0),
					new Vector3D(851,595,0),
					new Vector3D(1005,593,0),
					new Vector3D(1065,588,0),
					new Vector3D(1113,561,0),
					new Vector3D(1142,493,0),
					new Vector3D(1199,206,0),
					new Vector3D(1370,106,0),
					new Vector3D(1568,105,0),
					new Vector3D(1610,88,0),
					new Vector3D(1726,-7,0),
					new Vector3D(1789,81,0),
					new Vector3D(1791,176,0),
					new Vector3D(1829,251,0),
					new Vector3D(1818,317,0),
					new Vector3D(1984,749,0),
					new Vector3D(1971,798,0),
					new Vector3D(1932,888,0),
					new Vector3D(1826,1002,0),
					new Vector3D(1776,1227,0),
					new Vector3D(1764,1437,0),
					new Vector3D(1694,1543,0),
					new Vector3D(1657,1658,0),
					new Vector3D(1590,1721,0),
					new Vector3D(1509,2222,0),
					new Vector3D(1510,2521,0),
					new Vector3D(884,2740,0),
					new Vector3D(311,1906,0),
					new Vector3D(658,1783,0),
					new Vector3D(782,1787,0),
					new Vector3D(856,1533,0),
					new Vector3D(836,1466,0),
					new Vector3D(779,1406,0),
					new Vector3D(693,1229,0),
					new Vector3D(523,1133,0),
					new Vector3D(442,1060,0),
					new Vector3D(334,992,0),
					new Vector3D(223,1026,0),
					new Vector3D(66,1028,0)};

}