//
// WRITTEN BY JOSH NIMOY, AUG 2001, for Victoria Vesna, SINAPSE
// 
// If you use this code, I'm interested in knowing what you use it for.
// Please drop me a line - jtnimoy@ucla.edu or nimoy@media.mit.edu
//
//


import java.applet.*;
import java.awt.*;

public class sinapseSplash extends Applet implements Runnable{
	public int time=0;
	public Thread thread;
	public NimoyGL ngl;
	public UCLA ucla;
	public DestColor uclaAreaFill;
	public DestColor uclaBuildingFill;
	public DestColor uclaBuildingStroke;
	public DestColor borderStroke;
	public DestVector3D viewRotator;
	public DestVector3D viewScaler;
	public float rotBookMark=-1;
	public boolean mouseInBorder;
	public boolean mouseIsDown;

	public Sprite button1;
	public Sprite button2;

	public CentralizedNetwork centralizedNetwork;
	public DecentralizedNetwork decentralizedNetwork;

	public String statusMessage="";

	public String consoleBuffer = "";

	public void init(){
		setBackground(Color.white);
		ngl = new NimoyGL(640,480,this);
		ucla = new UCLA();	
		uclaAreaFill = new DestColor(255,255,255,255,250,230,30.0f);
		uclaBuildingFill = new DestColor(255,255,255,220,230,230,30.0f);
		uclaBuildingStroke = new DestColor(255,255,255,200,190,180,30.0f);
		borderStroke  = new DestColor(255,255,255,200,200,200,100.0f);
		viewRotator = new DestVector3D(new Vector3D(0.0f,0.0f,0.0f),new Vector3D(0.0f,0.0f,0.0f),1.0f);
		viewScaler = new DestVector3D(new Vector3D(0.08f,0.08f,0.08f),new Vector3D(0.08f,0.08f,0.08f),1.0f);

		centralizedNetwork = new CentralizedNetwork(this);
		decentralizedNetwork = new DecentralizedNetwork(this);

		button1 = new Sprite(
			centralizedNetwork.darkR,centralizedNetwork.darkG,centralizedNetwork.darkB,
			centralizedNetwork.lightR,centralizedNetwork.lightG,centralizedNetwork.lightB,
			255,0,0,
			320+(320/2)-14,240+(240/2)+5,14,14,true,this,"Show/Hide Centralized Networking");

		
		button2 = new Sprite(
			decentralizedNetwork.darkR,decentralizedNetwork.darkG,decentralizedNetwork.darkB,
			decentralizedNetwork.lightR,decentralizedNetwork.lightG,decentralizedNetwork.lightB,
			255,0,0,
			320+(320/2)-(14*2+4),240+(240/2)+5,14,14,true,this,"Show/Hide Decentralized Networking");
		System.out.println("Click applet, type \"illustrator\" and hit enter to export.");
	}

	public void paint(Graphics g){
		ngl.clear();
		ngl.setColor(borderStroke.getColor());
		ngl.drawRect(320-(320/2),240-(240/2),320+(320/2),240+(240/2));
	
		ngl.pushMatrix();
			ngl.translate(size().width/2,size().height/2,0);
			ngl.rotateX(-viewRotator.curVector.x);
			ngl.rotateZ(-viewRotator.curVector.x);
			ngl.scale(viewScaler.curVector);
			ngl.translate(-1000,-1400,0);

			//draw peach colored UCLA ground area
			ngl.setColor(uclaAreaFill.getColor());
			ngl.fillPolygon(ucla.areaShape,ucla.areaCount);
			
			
			ngl.pushMatrix();
			//draw building fills
			ngl.setColor(uclaBuildingFill.getColor());
			for(int i=0;i<ucla.buildingCount;i++){
				ngl.pushMatrix();
					ngl.translate(ucla.buildings[i].curTranslation.x,
						ucla.buildings[i].curTranslation.y,0.0f);
					ngl.fillPolygon(ucla.buildings[i].vectors,ucla.buildings[i].size);
				ngl.popMatrix();
			}
			ngl.popMatrix();

			ngl.translate(0.0f,0.0f,100f);

			if(mouseInBorder)paintNetworks();
			//draw building strokes
			ngl.setColor(uclaBuildingStroke.getColor());

			ngl.pushMatrix();
			for(int i=0;i<ucla.buildingCount;i++){
				ngl.pushMatrix();
					ngl.translate(ucla.buildings[i].curTranslation.x,
						ucla.buildings[i].curTranslation.y,0.0f);
					ngl.drawPolygon(ucla.buildings[i].vectors,ucla.buildings[i].size);
				ngl.popMatrix();
			}
			ngl.popMatrix();

			if(!mouseInBorder)paintNetworks();

		ngl.popMatrix();
		ngl.pushMatrix();
		button1.draw();
		button2.draw();

		ngl.popMatrix();

		//display
		g.drawImage(ngl.image,0,0,Color.white,this);
	}

	public void paintNetworks(){
		if(mouseInBorder){
			//so the green is in front when we're up close - it's prettier (in my opinion)
			decentralizedNetwork.paint();
			centralizedNetwork.paint();
		}else{
			centralizedNetwork.paint();
			decentralizedNetwork.paint();
		}
	}

	public boolean mouseDown(Event e,int x,int y){
		statusMessage = "";
		pickCheck(x,y);
		//go to sinapse typography configuration
		if(mouseInBorder){
			viewRotator.setDest(0.0f,0.0f,0.0f,10.0f);
			for(int i=0;i<ucla.buildingCount;i++)
				ucla.buildings[i].destTranslation=ucla.buildings[i].typeTranslation;
			if(time>70){
				uclaBuildingStroke.setDest(150,150,150,5.0f);
				//uclaBuildingFill.setDest(210,210,210,10.0f);
			}
		}
		if(button1.mouseInside){
			button1.mouseIsDown=true;
			button1.mouseDown(x,y);
			if(button1.checked)centralizedNetwork.enable();
			else centralizedNetwork.disable();
		}
		if(button2.mouseInside){
			button2.mouseIsDown=true;
			button2.mouseDown(x,y);
			if(button2.checked)decentralizedNetwork.enable();
			else decentralizedNetwork.disable();
		}

		mouseIsDown = true;
		return true;
	}

	public boolean mouseUp(Event e,int x,int y){
		pickCheck(x,y);
		//go back to campus map config configuration
		for(int i=0;i<ucla.buildingCount;i++)
			ucla.buildings[i].destTranslation=new Vector3D(0.0f,0.0f,0.0f);

		if(mouseInBorder){
			viewRotator.setDest(rotBookMark,rotBookMark,rotBookMark,10.0f);
			if(time>70){
				//uclaBuildingFill.setDest(255,255,255,5.0f);
				uclaBuildingStroke.setDest(210,210,210,5.0f);
			}
		}
		if(button1.mouseInside){
			button1.mouseIsDown=false;
			button1.mouseUp(x,y);
		}else if(button1.mouseIsDown){
			button1.mouseIsDown=false;
			button1.mouseUpOutside(x,y);
		}

		if(button2.mouseInside){
			button2.mouseIsDown=false;
			button2.mouseUp(x,y);
		}else if(button2.mouseIsDown){
			button2.mouseIsDown=false;
			button2.mouseUpOutside(x,y);
		}

		mouseIsDown = false;
		return true;
	}

	public boolean mouseDrag(Event e,int x,int y){
		if(!mouseIsDown)mouseIsDown=true;
		return mouseMove(e,x,y);
	}

	public boolean mouseMove(Event e,int x,int y){
		pickCheck(x,y);
		showStatus(statusMessage);
		return true;
	}


	public void borderMouseEnter(){
		if(time>70){
			//get rid of that slight momentum
			viewRotator.destVector.x=viewRotator.curVector.x;
			viewScaler.setDest(0.15f,0.15f,0.15f,3.0f);
			rotBookMark = viewRotator.curVector.x;
			uclaAreaFill.setDest(255,255,255,5.0f);
			uclaBuildingFill.setDest(255,255,255,5.0f);
			uclaBuildingStroke.setDest(210,210,210,5.0f);
			borderStroke.setDest(255,255,255,5.0f);
			//tell the children
			centralizedNetwork.borderMouseEnter();
			decentralizedNetwork.borderMouseEnter();
			button1.borderMouseEnter();
			button2.borderMouseEnter();
			statusMessage = "Hold your mouse button down for a surprise!";
		}
	}


	public void borderMouseLeave(){
		if(time>70){
			rotBookMark=-1;
			viewScaler.setDest(0.08f,0.08f,0.08f,3.0f);
			uclaAreaFill.setDest(255,250,230,5.0f);
			uclaBuildingFill.setDest(220,230,230,5.0f);
			uclaBuildingStroke.setDest(200,190,180,5.0f);
			borderStroke.setDest(200,200,200,10.0f);

			//go back to campus map config configuration
			for(int i=0;i<ucla.buildingCount;i++)
				ucla.buildings[i].destTranslation=new Vector3D(0.0f,0.0f,0.0f);
			viewRotator.destVector.x=viewRotator.curVector.x;

			//tell the children
			centralizedNetwork.borderMouseLeave();
			decentralizedNetwork.borderMouseLeave();
			button1.borderMouseLeave();
			button2.borderMouseLeave();
			statusMessage = "";
		}

	}

	public void frame(){
		time++;

		if(time>70){
			viewRotator.frame();
			centralizedNetwork.frame();
			decentralizedNetwork.frame();

			if(!mouseInBorder){
			//incrementing the view,
			//making sure it stays within range
			//don't want too much twisting when the time comes
				if(++viewRotator.destVector.x>=360)
					viewRotator.destVector.x=0;
				viewRotator.curVector.x=viewRotator.destVector.x;
				//also let the networks carry on if we're not taking a look at it
			}

			viewScaler.frame();
			ucla.frame();
		}
		button1.frame();
		button2.frame();
		uclaAreaFill.frame();
		uclaBuildingFill.frame();
		uclaBuildingStroke.frame();
		borderStroke.frame();
		repaint();
	}

	public void pickCheck(int x,int y){

		//mouse inside the picture border?
		if((x<320+(320/2) && x>320-(320/2))&&(y<240+(240/2) && y>240-(240/2))){
			if(!mouseInBorder){
				mouseInBorder=true;
				borderMouseEnter();
			}
		}else{
			if(mouseInBorder){
				mouseInBorder=false;
				borderMouseLeave();
			}
		}

		if(button1.pickCheck(x,y)){
			if(!button1.mouseInside){
				button1.mouseInside=true;
				button1.mouseEnter(x,y);
			}
		}else{
			if(button1.mouseInside){
				button1.mouseInside=false;
				button1.mouseLeave(x,y);
			}
		}

		if(button2.pickCheck(x,y)){
			if(!button2.mouseInside){
				button2.mouseInside=true;
				button2.mouseEnter(x,y);
			}
		}else{
			if(button2.mouseInside){
				button2.mouseInside=false;
				button2.mouseLeave(x,y);
			}
		}

	}
	public void start(){
		if(thread==null){
			thread = new Thread(this,"NimoyGL Animation");
			thread.setPriority(Thread.MAX_PRIORITY);
			thread.start();
		}
	}
	public void run(){
		while(thread!=null){
			frame();
			try{
				thread.sleep(50);
			}catch(InterruptedException e){}
		}
	}
	public void stop(){
		if(thread!=null){
			thread.stop();
			thread=null;
		}
	}
	public void update(Graphics g){
		paint(g);
	}
	public boolean keyDown(Event e, int k){
		if(k==10){//enter - so interpet buffer
			System.out.print("\n");
			if(consoleBuffer.equalsIgnoreCase("illustrator")){
				ngl.enableIllustrator();
				paint(getGraphics());
				ngl.disableIllustrator();
			}else{
				System.out.println("command not recognized");
			}
			consoleBuffer="";
		}else {
			consoleBuffer+=(char)k;
			System.out.print((char)k);
		}
		return true;
	}

}
